/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.XPathException;

public final class ConvertToString
extends UnaryExpression {
    public ConvertToString(Expression expression) {
        super(expression);
    }

    public ItemType getItemType() {
        return Type.STRING_TYPE;
    }

    public Expression analyze(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.operand = this.operand.analyze(staticContext, itemType);
        if (this.operand.getCardinality() == 512 && Type.isSubType(this.operand.getItemType(), Type.STRING_TYPE)) {
            return this.operand;
        }
        return this;
    }

    public int computeCardinality() {
        return 512;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.operand.iterate(xPathContext);
        Item item = sequenceIterator.next();
        if (item == null) {
            return StringValue.EMPTY_STRING;
        }
        return new StringValue(item.getStringValue());
    }

    public String displayOperator(NamePool namePool) {
        return "convert to string";
    }
}

