/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.PrintStream;
import java.util.Iterator;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.DynamicError;
import net.sf.saxon.xpath.XPathException;

public abstract class UnaryExpression
extends ComputedExpression {
    protected Expression operand;

    public UnaryExpression(Expression expression) {
        this.operand = expression;
        this.adoptChildExpression(expression);
    }

    public Expression getBaseExpression() {
        return this.operand;
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.operand = this.operand.simplify(staticContext);
        return this;
    }

    public Expression analyze(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.operand = this.operand.analyze(staticContext, itemType);
        try {
            if (this.operand instanceof Value) {
                return ExpressionTool.eagerEvaluate(this, null);
            }
        }
        catch (DynamicError dynamicError) {}
        return this;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        this.operand = this.operand.promote(promotionOffer);
        return this;
    }

    public Iterator iterateSubExpressions() {
        return new MonoIterator(this.operand);
    }

    public int computeSpecialProperties() {
        return this.operand.getSpecialProperties();
    }

    public int computeCardinality() {
        return this.operand.getCardinality();
    }

    public ItemType getItemType() {
        return this.operand.getItemType();
    }

    public boolean equals(Object object) {
        return this.getClass().equals(object.getClass()) && this.operand.equals(((UnaryExpression)object).operand);
    }

    public int hashCode() {
        return ("UnaryExpression " + this.getClass()).hashCode() ^ this.operand.hashCode();
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        printStream.println(ExpressionTool.indent(n) + this.displayOperator(namePool));
        this.operand.display(n + 1, namePool, printStream);
    }

    protected abstract String displayOperator(NamePool var1);
}

