/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree;

import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tree.AttributeCollection;
import net.sf.saxon.tree.ElementImpl;
import net.sf.saxon.tree.NodeImpl;
import net.sf.saxon.xpath.XPathException;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

final class AttributeImpl
extends NodeImpl
implements Attr {
    private int nameCode;
    private String value;

    public AttributeImpl(ElementImpl elementImpl, int n) {
        this.parent = elementImpl;
        this.index = n;
        AttributeCollection attributeCollection = elementImpl.getAttributeList();
        this.nameCode = attributeCollection.getNameCode(n);
        this.value = attributeCollection.getValue(n);
    }

    public int getNameCode() {
        return this.nameCode;
    }

    public boolean isSameNodeInfo(NodeInfo nodeInfo) {
        if (!(nodeInfo instanceof AttributeImpl)) {
            return false;
        }
        if (this == nodeInfo) {
            return true;
        }
        AttributeImpl attributeImpl = (AttributeImpl)nodeInfo;
        return this.parent.isSameNode(attributeImpl.parent) && (this.nameCode & 0xFFFFF) == (attributeImpl.nameCode & 0xFFFFF);
    }

    protected long getSequenceNumber() {
        return this.parent.getSequenceNumber() + 32768L + (long)this.index;
    }

    public final int getNodeKind() {
        return 2;
    }

    public String getStringValue() {
        return this.value;
    }

    public Node getNextSibling() {
        return null;
    }

    public Node getPreviousSibling() {
        return null;
    }

    public NodeImpl getPreviousInDocument() {
        return (NodeImpl)this.getParent();
    }

    public NodeImpl getNextInDocument(NodeImpl nodeImpl) {
        if (nodeImpl == this) {
            return null;
        }
        return ((NodeImpl)this.getParent()).getNextInDocument(nodeImpl);
    }

    public String generateId() {
        return this.parent.generateId() + "_" + this.getDisplayName();
    }

    public void copy(Receiver receiver, int n) throws XPathException {
        int n2 = this.getNameCode();
        receiver.attribute(n2, -1, this.getStringValue(), 0, 0);
    }
}

