/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.ICULocaleService;
import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.impl.ICUService;
import com.ibm.icu.impl.LocaleUtility;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.CollatorServiceShim;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.util.ULocale;
import java.util.Locale;
import java.util.Set;

final class CollatorServiceShim
extends Collator.ServiceShim {
    private static ICULocaleService service = new CService();

    CollatorServiceShim() {
    }

    Collator getInstance(ULocale locale) {
        try {
            ULocale[] actualLoc = new ULocale[1];
            Collator coll = (Collator)service.get(locale, actualLoc);
            coll = (Collator)coll.clone();
            coll.setLocale(actualLoc[0], actualLoc[0]);
            return coll;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.getMessage());
        }
    }

    Object registerInstance(Collator collator, Locale locale) {
        return service.registerObject((Object)collator, locale);
    }

    Object registerFactory(Collator.CollatorFactory f) {
        class CFactory
        extends ICULocaleService.LocaleKeyFactory {
            Collator.CollatorFactory delegate;

            CFactory(Collator.CollatorFactory f) {
                super(f.visible() ? 0 : 1, "CFactory");
                this.delegate = f;
            }

            public Object handleCreate(Locale loc, int kind, ICUService service) {
                Collator coll = this.delegate.createCollator(loc);
                return coll;
            }

            public String getDisplayName(String id, Locale displayLocale) {
                Locale objectLocale = LocaleUtility.getLocaleFromName(id);
                return this.delegate.getDisplayName(objectLocale, displayLocale);
            }

            public Set getSupportedIDs() {
                return this.delegate.getSupportedLocaleIDs();
            }
        }
        return service.registerFactory(new CFactory(f));
    }

    boolean unregister(Object registryKey) {
        return service.unregisterFactory((ICUService.Factory)registryKey);
    }

    Locale[] getAvailableLocales() {
        if (service.isDefault()) {
            return ICUResourceBundle.getAvailableLocales("com/ibm/icu/impl/data/icudt30b/coll");
        }
        return service.getAvailableLocales();
    }

    ULocale[] getAvailableULocales() {
        if (service.isDefault()) {
            return ICUResourceBundle.getAvailableULocales("com/ibm/icu/impl/data/icudt30b/coll");
        }
        return service.getAvailableULocales();
    }

    String getDisplayName(Locale objectLocale, Locale displayLocale) {
        String id = LocaleUtility.canonicalLocaleString(objectLocale);
        return service.getDisplayName(id, displayLocale);
    }

    private static class CService
    extends ICULocaleService {
        CService() {
            super("Collator");
            class CollatorFactory
            extends ICULocaleService.ICUResourceBundleFactory {
                private final /* synthetic */ CService this$0;

                CollatorFactory(CService this$0) {
                    this.this$0 = this$0;
                }

                protected Object handleCreate(ULocale uloc, int kind, ICUService service) {
                    return new RuleBasedCollator(uloc);
                }

                protected boolean supportsULocale() {
                    return true;
                }

                protected Set getSupportedIDs() {
                    return ICUResourceBundle.getAvailableLocaleNameSet("com/ibm/icu/impl/data/icudt30b/coll");
                }
            }
            this.registerFactory(new CollatorFactory(this));
            this.markDefault();
        }

        protected Object handleDefault(ICUService.Key key, String[] actualIDReturn) {
            if (actualIDReturn != null) {
                actualIDReturn[0] = "root";
            }
            return new RuleBasedCollator(ULocale.ROOT);
        }
    }
}

