/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.util;

import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.util.UResourceBundle;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.TreeMap;

public final class ULocale
implements Serializable {
    public static final ULocale ENGLISH = new ULocale("en", Locale.ENGLISH);
    public static final ULocale FRENCH = new ULocale("fr", Locale.FRENCH);
    public static final ULocale GERMAN = new ULocale("de", Locale.GERMAN);
    public static final ULocale ITALIAN = new ULocale("it", Locale.ITALIAN);
    public static final ULocale JAPANESE = new ULocale("ja", Locale.JAPANESE);
    public static final ULocale KOREAN = new ULocale("ko", Locale.KOREAN);
    public static final ULocale CHINESE = new ULocale("zh", Locale.CHINESE);
    public static final ULocale SIMPLIFIED_CHINESE = new ULocale("zh_Hans", Locale.CHINESE);
    public static final ULocale TRADITIONAL_CHINESE = new ULocale("zh_Hant", Locale.CHINESE);
    public static final ULocale FRANCE = new ULocale("fr_FR", Locale.FRANCE);
    public static final ULocale GERMANY = new ULocale("de_DE", Locale.GERMANY);
    public static final ULocale ITALY = new ULocale("it_IT", Locale.ITALY);
    public static final ULocale JAPAN = new ULocale("ja_JP", Locale.JAPAN);
    public static final ULocale KOREA = new ULocale("ko_KR", Locale.KOREA);
    public static final ULocale CHINA;
    public static final ULocale PRC;
    public static final ULocale TAIWAN;
    public static final ULocale UK;
    public static final ULocale US;
    public static final ULocale CANADA;
    public static final ULocale CANADA_FRENCH;
    private static final String EMPTY_STRING = "";
    private static final char UNDERSCORE = '_';
    public static final ULocale ROOT;
    private transient Locale locale;
    private String localeID;
    private static String[] _languages;
    private static String[] _replacementLanguages;
    private static String[] _obsoleteLanguages;
    private static String[] _languages3;
    private static String[] _obsoleteLanguages3;
    private static String[] _countries;
    private static String[] _obsoleteCountries;
    private static String[] _countries3;
    private static String[] _obsoleteCountries3;
    private static String[][] _variantsToKeywords;
    private static ULocale defaultULocale;
    public static Type ACTUAL_LOCALE;
    public static Type VALID_LOCALE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initLanguageTables() {
        if (_languages == null) {
            String[] tempLanguages = new String[]{"aa", "ab", "ace", "ach", "ada", "ady", "ae", "af", "afa", "afh", "ak", "akk", "ale", "alg", "am", "an", "ang", "apa", "ar", "arc", "arn", "arp", "art", "arw", "as", "ast", "ath", "aus", "av", "awa", "ay", "az", "ba", "bad", "bai", "bal", "bam", "ban", "bas", "bat", "be", "bej", "bem", "ber", "bg", "bh", "bho", "bi", "bik", "bin", "bla", "bm", "bn", "bnt", "bo", "br", "bra", "bs", "btk", "bua", "bug", "byn", "ca", "cad", "cai", "car", "cau", "ce", "ceb", "cel", "ch", "chb", "chg", "chk", "chm", "chn", "cho", "chp", "chr", "chy", "cmc", "co", "cop", "cpe", "cpf", "cpp", "cr", "crh", "crp", "cs", "csb", "cu", "cus", "cv", "cy", "da", "dak", "dar", "day", "de", "del", "den", "dgr", "din", "doi", "dra", "dsb", "dua", "dum", "dv", "dyu", "dz", "ee", "efi", "egy", "eka", "el", "elx", "en", "enm", "eo", "es", "et", "eu", "ewo", "fa", "fan", "fat", "ff", "fi", "fiu", "fj", "fo", "fon", "fr", "frm", "fro", "fur", "fy", "ga", "gaa", "gay", "gba", "gd", "gem", "gez", "gil", "gl", "gmh", "gn", "goh", "gon", "gor", "got", "grb", "grc", "gu", "gv", "gwi", "ha", "hai", "haw", "he", "hi", "hil", "him", "hit", "hmn", "ho", "hr", "hsb", "ht", "hu", "hup", "hy", "hz", "ia", "iba", "id", "ie", "ig", "ii", "ijo", "ik", "ilo", "inc", "ine", "inh", "io", "ira", "iro", "is", "it", "iu", "ja", "jbo", "jpr", "jrb", "jv", "ka", "kaa", "kab", "kac", "kam", "kar", "kaw", "kbd", "kg", "kha", "khi", "kho", "ki", "kj", "kk", "kl", "km", "kmb", "kn", "ko", "kok", "kos", "kpe", "kr", "krc", "kro", "kru", "ks", "ku", "kum", "kut", "kv", "kw", "ky", "la", "lad", "lah", "lam", "lb", "lez", "lg", "li", "ln", "lo", "lol", "loz", "lt", "lu", "lua", "lui", "lun", "luo", "lus", "lv", "mad", "mag", "mai", "mak", "man", "map", "mas", "mdf", "mdr", "men", "mg", "mga", "mh", "mi", "mic", "min", "mis", "mk", "mkh", "ml", "mn", "mnc", "mni", "mno", "mo", "moh", "mos", "mr", "ms", "mt", "mul", "mun", "mus", "mwr", "my", "myn", "myv", "na", "nah", "nai", "nap", "nb", "nd", "nds", "ne", "new", "ng", "nia", "nic", "niu", "nl", "nn", "no", "nog", "non", "nr", "nso", "nub", "nv", "ny", "nym", "nyn", "nyo", "nzi", "oc", "oj", "om", "or", "os", "osa", "ota", "oto", "pa", "paa", "pag", "pal", "pam", "pap", "pau", "peo", "phi", "phn", "pi", "pl", "pon", "pra", "pro", "ps", "pt", "qu", "raj", "rap", "rar", "rm", "rn", "ro", "roa", "rom", "ru", "rw", "sa", "sad", "sah", "sai", "sal", "sam", "sas", "sat", "sc", "sco", "sd", "se", "sel", "sem", "sg", "sga", "sgn", "shn", "si", "sid", "sio", "sit", "sk", "sl", "sla", "sm", "sma", "smi", "smj", "smn", "sms", "sn", "snk", "so", "sog", "son", "sq", "sr", "srr", "ss", "ssa", "st", "su", "suk", "sus", "sux", "sv", "sw", "syr", "ta", "tai", "te", "tem", "ter", "tet", "tg", "th", "ti", "tig", "tiv", "tk", "tkl", "tl", "tli", "tmh", "tn", "to", "tog", "tpi", "tr", "ts", "tsi", "tt", "tum", "tup", "tut", "tvl", "tw", "ty", "tyv", "udm", "ug", "uga", "uk", "umb", "und", "ur", "uz", "vai", "ve", "vi", "vo", "vot", "wa", "wak", "wal", "war", "was", "wen", "wo", "xal", "xh", "yao", "yap", "yi", "yo", "ypk", "za", "zap", "zen", "zh", "znd", "zu", "zun"};
            String[] tempReplacementLanguages = new String[]{"id", "he", "yi", "jv", "sr", "nb"};
            String[] tempObsoleteLanguages = new String[]{"in", "iw", "ji", "jw", "sh", "no"};
            String[] tempLanguages3 = new String[]{"aar", "abk", "ace", "ach", "ada", "ady", "ave", "afr", "afa", "afh", "aka", "akk", "ale", "alg", "amh", "arg", "ang", "apa", "ara", "arc", "arn", "arp", "art", "arw", "asm", "ast", "ath", "aus", "ava", "awa", "aym", "aze", "bak", "bad", "bai", "bal", "bam", "ban", "bas", "bat", "bel", "bej", "bem", "ber", "bul", "bih", "bho", "bis", "bik", "bin", "bla", "bm", "ben", "bnt", "bod", "bre", "bra", "bos", "btk", "bua", "bug", "byn", "cat", "cad", "cai", "car", "cau", "che", "ceb", "cel", "cha", "chb", "chg", "chk", "chm", "chn", "cho", "chp", "chr", "chy", "cmc", "cos", "cop", "cpe", "cpf", "cpp", "cre", "crh", "crp", "ces", "csb", "chu", "cus", "chv", "cym", "dan", "dak", "dar", "day", "deu", "del", "den", "dgr", "din", "doi", "dra", "dsb", "dua", "dum", "div", "dyu", "dzo", "ewe", "efi", "egy", "eka", "ell", "elx", "eng", "enm", "epo", "spa", "est", "eus", "ewo", "fas", "fan", "fat", "ful", "fin", "fiu", "fij", "fao", "fon", "fra", "frm", "fro", "fur", "fry", "gle", "gaa", "gay", "gba", "gla", "gem", "gez", "gil", "glg", "gmh", "grn", "goh", "gon", "gor", "got", "grb", "grc", "guj", "glv", "gwi", "hau", "hai", "haw", "heb", "hin", "hil", "him", "hit", "hmn", "hmo", "hrv", "hsb", "hat", "hun", "hup", "hye", "her", "ina", "iba", "ind", "ile", "ibo", "iii", "ijo", "ipk", "ilo", "inc", "ine", "inh", "ido", "ira", "iro", "isl", "ita", "iku", "jpn", "jbo", "jpr", "jrb", "jaw", "kat", "kaa", "kab", "kac", "kam", "kar", "kaw", "kbd", "kon", "kha", "khi", "kho", "kik", "kua", "kaz", "kal", "khm", "kmb", "kan", "kor", "kok", "kos", "kpe", "kau", "krc", "kro", "kru", "kas", "kur", "kum", "kut", "kom", "cor", "kir", "lat", "lad", "lah", "lam", "ltz", "lez", "lug", "lim", "lin", "lao", "lol", "loz", "lit", "lub", "lua", "lui", "lun", "luo", "lus", "lav", "mad", "mag", "mai", "mak", "man", "map", "mas", "mdf", "mdr", "men", "mlg", "mga", "mah", "mri", "mic", "min", "mis", "mkd", "mkh", "mal", "mon", "mnc", "mni", "mno", "mol", "moh", "mos", "mar", "msa", "mlt", "mul", "mun", "mus", "mwr", "mya", "myn", "myv", "nau", "nah", "nai", "nap", "nob", "nde", "nds", "nep", "new", "ndo", "nia", "nic", "niu", "nld", "nno", "nor", "nog", "non", "nbl", "nso", "nub", "nav", "nya", "nym", "nyn", "nyo", "nzi", "oci", "oji", "orm", "ori", "oss", "osa", "ota", "oto", "pan", "paa", "pag", "pal", "pam", "pap", "pau", "peo", "phi", "phn", "pli", "pol", "pon", "pra", "pro", "pus", "por", "que", "raj", "rap", "rar", "roh", "run", "ron", "roa", "rom", "rus", "kin", "san", "sad", "sah", "sai", "sal", "sam", "sas", "sat", "srd", "sco", "snd", "sme", "sel", "sem", "sag", "sga", "sgn", "shn", "sin", "sid", "sio", "sit", "slk", "slv", "sla", "smo", "sma", "smi", "smj", "smn", "sms", "sna", "snk", "som", "sog", "son", "sqi", "srp", "srr", "ssw", "ssa", "sot", "sun", "suk", "sus", "sux", "swe", "swa", "syr", "tam", "tai", "tel", "tem", "ter", "tet", "tgk", "tha", "tir", "tig", "tiv", "tuk", "tkl", "tgl", "tli", "tmh", "tsn", "ton", "tog", "tpi", "tur", "tso", "tsi", "tat", "tum", "tup", "tut", "tvl", "twi", "tah", "tyv", "udm", "uig", "uga", "ukr", "umb", "und", "urd", "uzb", "vai", "ven", "vie", "vol", "vot", "wln", "wak", "wal", "war", "was", "wen", "wol", "xal", "xho", "yao", "yap", "yid", "yor", "ypk", "zha", "zap", "zen", "zho", "znd", "zul", "zun"};
            String[] tempObsoleteLanguages3 = new String[]{"ind", "heb", "yid", "jaw", "srp"};
            Class clazz = ULocale.class;
            synchronized (clazz) {
                if (_languages == null) {
                    _languages = tempLanguages;
                    _replacementLanguages = tempReplacementLanguages;
                    _obsoleteLanguages = tempObsoleteLanguages;
                    _languages3 = tempLanguages3;
                    _obsoleteLanguages3 = tempObsoleteLanguages3;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initCountryTables() {
        if (_countries == null) {
            String[] tempCountries = new String[]{"AD", "AE", "AF", "AG", "AI", "AL", "AM", "AN", "AO", "AQ", "AR", "AS", "AT", "AU", "AW", "AZ", "BA", "BB", "BD", "BE", "BF", "BG", "BH", "BI", "BJ", "BM", "BN", "BO", "BR", "BS", "BT", "BV", "BW", "BY", "BZ", "CA", "CC", "CD", "CF", "CG", "CH", "CI", "CK", "CL", "CM", "CN", "CO", "CR", "CU", "CV", "CX", "CY", "CZ", "DE", "DJ", "DK", "DM", "DO", "DZ", "EC", "EE", "EG", "EH", "ER", "ES", "ET", "FI", "FJ", "FK", "FM", "FO", "FR", "GA", "GB", "GD", "GE", "GF", "GH", "GI", "GL", "GM", "GN", "GP", "GQ", "GR", "GS", "GT", "GU", "GW", "GY", "HK", "HM", "HN", "HR", "HT", "HU", "ID", "IE", "IL", "IN", "IO", "IQ", "IR", "IS", "IT", "JM", "JO", "JP", "KE", "KG", "KH", "KI", "KM", "KN", "KP", "KR", "KW", "KY", "KZ", "LA", "LB", "LC", "LI", "LK", "LR", "LS", "LT", "LU", "LV", "LY", "MA", "MC", "MD", "MG", "MH", "MK", "ML", "MM", "MN", "MO", "MP", "MQ", "MR", "MS", "MT", "MU", "MV", "MW", "MX", "MY", "MZ", "NA", "NC", "NE", "NF", "NG", "NI", "NL", "NO", "NP", "NR", "NU", "NZ", "OM", "PA", "PE", "PF", "PG", "PH", "PK", "PL", "PM", "PN", "PR", "PS", "PT", "PW", "PY", "QA", "RE", "RO", "RU", "RW", "SA", "SB", "SC", "SD", "SE", "SG", "SH", "SI", "SJ", "SK", "SL", "SM", "SN", "SO", "SR", "ST", "SV", "SY", "SZ", "TC", "TD", "TF", "TG", "TH", "TJ", "TK", "TL", "TM", "TN", "TO", "TR", "TT", "TV", "TW", "TZ", "UA", "UG", "UM", "US", "UY", "UZ", "VA", "VC", "VE", "VG", "VI", "VN", "VU", "WF", "WS", "YE", "YT", "YU", "ZA", "ZM", "ZW"};
            String[] tempObsoleteCountries = new String[]{"FX", "RO", "TP", "ZR"};
            String[] tempCountries3 = new String[]{"AND", "ARE", "AFG", "ATG", "AIA", "ALB", "ARM", "ANT", "AGO", "ATA", "ARG", "ASM", "AUT", "AUS", "ABW", "AZE", "BIH", "BRB", "BGD", "BEL", "BFA", "BGR", "BHR", "BDI", "BEN", "BMU", "BRN", "BOL", "BRA", "BHS", "BTN", "BVT", "BWA", "BLR", "BLZ", "CAN", "CCK", "COD", "CAF", "COG", "CHE", "CIV", "COK", "CHL", "CMR", "CHN", "COL", "CRI", "CUB", "CPV", "CXR", "CYP", "CZE", "DEU", "DJI", "DNK", "DMA", "DOM", "DZA", "ECU", "EST", "EGY", "ESH", "ERI", "ESP", "ETH", "FIN", "FJI", "FLK", "FSM", "FRO", "FRA", "GAB", "GBR", "GRD", "GEO", "GUF", "GHA", "GIB", "GRL", "GMB", "GIN", "GLP", "GNQ", "GRC", "SGS", "GTM", "GUM", "GNB", "GUY", "HKG", "HMD", "HND", "HRV", "HTI", "HUN", "IDN", "IRL", "ISR", "IND", "IOT", "IRQ", "IRN", "ISL", "ITA", "JAM", "JOR", "JPN", "KEN", "KGZ", "KHM", "KIR", "COM", "KNA", "PRK", "KOR", "KWT", "CYM", "KAZ", "LAO", "LBN", "LCA", "LIE", "LKA", "LBR", "LSO", "LTU", "LUX", "LVA", "LBY", "MAR", "MCO", "MDA", "MDG", "MHL", "MKD", "MLI", "MMR", "MNG", "MAC", "MNP", "MTQ", "MRT", "MSR", "MLT", "MUS", "MDV", "MWI", "MEX", "MYS", "MOZ", "NAM", "NCL", "NER", "NFK", "NGA", "NIC", "NLD", "NOR", "NPL", "NRU", "NIU", "NZL", "OMN", "PAN", "PER", "PYF", "PNG", "PHL", "PAK", "POL", "SPM", "PCN", "PRI", "PSE", "PRT", "PLW", "PRY", "QAT", "REU", "ROU", "RUS", "RWA", "SAU", "SLB", "SYC", "SDN", "SWE", "SGP", "SHN", "SVN", "SJM", "SVK", "SLE", "SMR", "SEN", "SOM", "SUR", "STP", "SLV", "SYR", "SWZ", "TCA", "TCD", "ATF", "TGO", "THA", "TJK", "TKL", "TLS", "TKM", "TUN", "TON", "TUR", "TTO", "TUV", "TWN", "TZA", "UKR", "UGA", "UMI", "USA", "URY", "UZB", "VAT", "VCT", "VEN", "VGB", "VIR", "VNM", "VUT", "WLF", "WSM", "YEM", "MYT", "YUG", "ZAF", "ZMB", "ZWE"};
            String[] tempObsoleteCountries3 = new String[]{"FXX", "ROM", "TMP", "ZAR"};
            Class clazz = ULocale.class;
            synchronized (clazz) {
                if (_countries == null) {
                    _countries = tempCountries;
                    _obsoleteCountries = tempObsoleteCountries;
                    _countries3 = tempCountries3;
                    _obsoleteCountries3 = tempObsoleteCountries3;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initVariantsTable() {
        if (_variantsToKeywords == null) {
            String[][] tempVariantsToKeywords = new String[][]{{"C", "en_US_POSIX", null, null}, {"art_LOJBAN", "jbo", null, null}, {"az_AZ_CYRL", "az_Cyrl_AZ", null, null}, {"az_AZ_LATN", "az_Latn_AZ", null, null}, {"ca_ES_PREEURO", "ca_ES", "currency", "ESP"}, {"cel_GAULISH", "cel__GAULISH", null, null}, {"de_1901", "de__1901", null, null}, {"de_1906", "de__1906", null, null}, {"de__PHONEBOOK", "de", "collation", "phonebook"}, {"de_AT_PREEURO", "de_AT", "currency", "ATS"}, {"de_DE_PREEURO", "de_DE", "currency", "DEM"}, {"de_LU_PREEURO", "de_LU", "currency", "EUR"}, {"el_GR_PREEURO", "el_GR", "currency", "GRD"}, {"en_BOONT", "en__BOONT", null, null}, {"en_SCOUSE", "en__SCOUSE", null, null}, {"en_BE_PREEURO", "en_BE", "currency", "BEF"}, {"en_IE_PREEURO", "en_IE", "currency", "IEP"}, {"es__TRADITIONAL", "es", "collation", "traditional"}, {"es_ES_PREEURO", "es_ES", "currency", "ESP"}, {"eu_ES_PREEURO", "eu_ES", "currency", "ESP"}, {"fi_FI_PREEURO", "fi_FI", "currency", "FIM"}, {"fr_BE_PREEURO", "fr_BE", "currency", "BEF"}, {"fr_FR_PREEURO", "fr_FR", "currency", "FRF"}, {"fr_LU_PREEURO", "fr_LU", "currency", "LUF"}, {"ga_IE_PREEURO", "ga_IE", "currency", "IEP"}, {"gl_ES_PREEURO", "gl_ES", "currency", "ESP"}, {"hi__DIRECT", "hi", "collation", "direct"}, {"it_IT_PREEURO", "it_IT", "currency", "ITL"}, {"ja_JP_TRADITIONAL", "ja_JP", "calendar", "japanese"}, {"nl_BE_PREEURO", "nl_BE", "currency", "BEF"}, {"nl_NL_PREEURO", "nl_NL", "currency", "NLG"}, {"pt_PT_PREEURO", "pt_PT", "currency", "PTE"}, {"sl_ROZAJ", "sl__ROZAJ", null, null}, {"sr_SP_CYRL", "sr_Cyrl_SP", null, null}, {"sr_SP_LATN", "sr_Latn_SP", null, null}, {"uz_UZ_CYRL", "uz_Cyrl_UZ", null, null}, {"uz_UZ_LATN", "uz_Latn_UZ", null, null}, {"zh_CHS", "zh_Hans", null, null}, {"zh_CHT", "zh_TW", null, null}, {"zh_GAN", "zh__GAN", null, null}, {"zh_GUOYU", "zh", null, null}, {"zh_HAKKA", "zh__HAKKA", null, null}, {"zh_MIN", "zh__MIN", null, null}, {"zh_MIN_NAN", "zh__MINNAN", null, null}, {"zh_WUU", "zh__WUU", null, null}, {"zh_XIANG", "zh__XIANG", null, null}, {"zh_YUE", "zh__YUE", null, null}, {"th_TH_TRADITIONAL", "th_TH", "calendar", "buddhist"}, {"zh_TW_STROKE", "zh_TW", "collation", "stroke"}, {"zh__PINYIN", "zh", "collation", "pinyin"}};
            Class clazz = ULocale.class;
            synchronized (clazz) {
                if (_variantsToKeywords == null) {
                    _variantsToKeywords = tempVariantsToKeywords;
                }
            }
        }
    }

    private ULocale(String localeID, Locale locale) {
        this.localeID = localeID;
        this.locale = locale;
    }

    public ULocale(Locale loc) {
        this.localeID = ULocale.getName(loc.toString());
        this.locale = loc;
    }

    public ULocale(String localeID) {
        this.localeID = ULocale.getName(localeID);
    }

    public ULocale(String a, String b, String c) {
        this.localeID = ULocale.getName(ULocale.lscvToID(a, b, c, EMPTY_STRING));
    }

    public static ULocale createCanonical(String nonCanonicalID) {
        return new ULocale(ULocale.canonicalize(nonCanonicalID), null);
    }

    private static String lscvToID(String lang, String script, String country, String variant) {
        StringBuffer buf = new StringBuffer();
        if (lang != null && lang.length() > 0) {
            buf.append(lang);
        }
        if (script != null && script.length() > 0) {
            buf.append('_');
            buf.append(script);
        }
        if (country != null && country.length() > 0) {
            buf.append('_');
            buf.append(country);
        }
        if (variant != null && variant.length() > 0) {
            if (country == null || country.length() == 0) {
                buf.append('_');
            }
            buf.append('_');
            buf.append(variant);
        }
        return buf.toString();
    }

    public Locale toLocale() {
        if (this.locale == null) {
            String[] names = new IDParser(this.localeID).getLanguageScriptCountryVariant();
            this.locale = new Locale(names[0], names[2], names[3]);
        }
        return this.locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ULocale getDefault() {
        Class clazz = ULocale.class;
        synchronized (clazz) {
            Locale defaultLocale = Locale.getDefault();
            if (defaultULocale == null || defaultULocale.toLocale() != defaultLocale) {
                defaultULocale = new ULocale(defaultLocale);
            }
            return defaultULocale;
        }
    }

    public static synchronized void setDefault(ULocale newLocale) {
        Locale.setDefault(newLocale.toLocale());
        defaultULocale = newLocale;
    }

    public Object clone() {
        return this;
    }

    public int hashCode() {
        return this.localeID.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof String) {
            return this.localeID.equals((String)obj);
        }
        if (obj instanceof ULocale) {
            return this.localeID.equals(((ULocale)obj).localeID);
        }
        return false;
    }

    public static ULocale[] getAvailableLocales() {
        return ICUResourceBundle.getAvailableULocales();
    }

    public static String[] getISOCountries() {
        ULocale.initCountryTables();
        return (String[])_countries.clone();
    }

    public static String[] getISOLanguages() {
        ULocale.initLanguageTables();
        return (String[])_languages.clone();
    }

    public String getLanguage() {
        return ULocale.getLanguage(this.localeID);
    }

    public static String getLanguage(String localeID) {
        return new IDParser(localeID).getLanguage();
    }

    public String getScript() {
        return ULocale.getScript(this.localeID);
    }

    public static String getScript(String localeID) {
        return new IDParser(localeID).getScript();
    }

    public String getCountry() {
        return ULocale.getCountry(this.localeID);
    }

    public static String getCountry(String localeID) {
        return new IDParser(localeID).getCountry();
    }

    public String getVariant() {
        return ULocale.getVariant(this.localeID);
    }

    public static String getVariant(String localeID) {
        return new IDParser(localeID).getVariant();
    }

    public String getBaseName() {
        return ULocale.getBaseName(this.localeID);
    }

    public static String getBaseName(String localeID) {
        return new IDParser(localeID).getBaseName();
    }

    public String getName() {
        return this.localeID;
    }

    public static String getName(String localeID) {
        return new IDParser(localeID).getName();
    }

    public String toString() {
        return this.localeID;
    }

    public Iterator getKeywords() {
        return ULocale.getKeywords(this.localeID);
    }

    public static Iterator getKeywords(String localeID) {
        return new IDParser(localeID).getKeywords();
    }

    public String getKeywordValue(String keywordName) {
        return ULocale.getKeywordValue(this.localeID, keywordName);
    }

    public static String getKeywordValue(String localeID, String keywordName) {
        return new IDParser(localeID).getKeywordValue(keywordName);
    }

    private static int findIndex(String[] array, String target) {
        for (int i = 0; i < array.length; ++i) {
            if (!target.equals(array[i])) continue;
            return i;
        }
        return -1;
    }

    public static String canonicalize(String localeID) {
        int idx;
        IDParser parser = new IDParser(localeID, true);
        String baseName = parser.getBaseName();
        boolean foundVariant = false;
        if (localeID.equals(EMPTY_STRING)) {
            return "en_US_POSIX";
        }
        ULocale.initVariantsTable();
        for (int i = 0; i < _variantsToKeywords.length; ++i) {
            if (!_variantsToKeywords[i][0].equals(baseName)) continue;
            foundVariant = true;
            String[] vals = _variantsToKeywords[i];
            parser.setBaseName(vals[1]);
            if (vals[2] == null) break;
            parser.defaultKeywordValue(vals[2], vals[3]);
            break;
        }
        if (!foundVariant && (idx = baseName.indexOf("_EURO")) > -1) {
            parser.setBaseName(baseName.substring(0, idx));
            parser.defaultKeywordValue("currency", "EUR");
        }
        if (!foundVariant && parser.getLanguage().equals("nb") && parser.getVariant().equals("NY")) {
            parser.setBaseName(ULocale.lscvToID("nn", parser.getScript(), parser.getCountry(), null));
        }
        return parser.getName();
    }

    private static String setKeywordValue(String localeID, String keyword, String value) {
        IDParser parser = new IDParser(localeID);
        parser.setKeywordValue(keyword, value);
        return parser.getName();
    }

    private static String defaultKeywordValue(String localeID, String keyword, String value) {
        IDParser parser = new IDParser(localeID);
        parser.defaultKeywordValue(keyword, value);
        return parser.getName();
    }

    public String getISO3Language() {
        return ULocale.getISO3Language(this.localeID);
    }

    public static String getISO3Language(String localeID) {
        ULocale.initLanguageTables();
        String language = ULocale.getLanguage(localeID);
        int offset = ULocale.findIndex(_languages, language);
        if (offset >= 0) {
            return _languages3[offset];
        }
        offset = ULocale.findIndex(_obsoleteLanguages, language);
        if (offset >= 0) {
            return _obsoleteLanguages3[offset];
        }
        return EMPTY_STRING;
    }

    public String getISO3Country() {
        return ULocale.getISO3Country(this.localeID);
    }

    public static String getISO3Country(String localeID) {
        ULocale.initCountryTables();
        String country = ULocale.getCountry(localeID);
        int offset = ULocale.findIndex(_countries, country);
        if (offset >= 0) {
            return _countries3[offset];
        }
        offset = ULocale.findIndex(_obsoleteCountries, country);
        if (offset >= 0) {
            return _obsoleteCountries3[offset];
        }
        return EMPTY_STRING;
    }

    private static String getTableString(String tableName, String subtableName, String item, String displayLocaleID) {
        if (item.length() > 0) {
            try {
                ICUResourceBundle bundle = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt30b", displayLocaleID);
                return ULocale.getTableString(tableName, subtableName, item, bundle);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return item;
    }

    private static String getTableString(String tableName, String subtableName, String item, ICUResourceBundle bundle) {
        try {
            while (true) {
                ICUResourceBundle table;
                if ("currency".equals(subtableName)) {
                    table = bundle.getWithFallback("Currencies");
                    table = table.getWithFallback(item);
                    return table.getString(1);
                }
                table = bundle.getWithFallback(tableName);
                try {
                    if (subtableName != null) {
                        table = bundle.getWithFallback(subtableName);
                    }
                    table = table.get(item);
                    return table.getString();
                }
                catch (MissingResourceException e) {
                    String fallbackLocale = table.getWithFallback("Fallback").getString();
                    if (fallbackLocale.length() == 0) {
                        fallbackLocale = "root";
                    }
                    if (fallbackLocale.equals(table.getULocale().localeID)) {
                        return item;
                    }
                    bundle = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt30b", fallbackLocale);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            return item;
        }
    }

    public String getDisplayLanguage() {
        return ULocale.getDisplayLanguageInternal(this.localeID, ULocale.getDefault().localeID);
    }

    public String getDisplayLanguage(ULocale displayLocale) {
        return ULocale.getDisplayLanguageInternal(this.localeID, displayLocale.localeID);
    }

    public static String getDisplayLanguage(String localeID, String displayLocaleID) {
        return ULocale.getDisplayLanguageInternal(localeID, ULocale.getName(displayLocaleID));
    }

    public static String getDisplayLanguage(String localeID, ULocale displayLocale) {
        return ULocale.getDisplayLanguageInternal(localeID, displayLocale.localeID);
    }

    private static String getDisplayLanguageInternal(String localeID, String displayLocaleID) {
        return ULocale.getTableString("Languages", null, new IDParser(localeID).getLanguage(), displayLocaleID);
    }

    public String getDisplayScript() {
        return ULocale.getDisplayScriptInternal(this.localeID, ULocale.getDefault().localeID);
    }

    public String getDisplayScript(ULocale displayLocale) {
        return ULocale.getDisplayScriptInternal(this.localeID, displayLocale.localeID);
    }

    public static String getDisplayScript(String localeID, String displayLocaleID) {
        return ULocale.getDisplayScriptInternal(localeID, ULocale.getName(displayLocaleID));
    }

    public static String getDisplayScript(String localeID, ULocale displayLocale) {
        return ULocale.getDisplayScriptInternal(localeID, displayLocale.localeID);
    }

    private static String getDisplayScriptInternal(String localeID, String displayLocaleID) {
        return ULocale.getTableString("Scripts", null, new IDParser(localeID).getScript(), displayLocaleID);
    }

    public String getDisplayCountry() {
        return ULocale.getDisplayCountryInternal(this.localeID, ULocale.getDefault().localeID);
    }

    public String getDisplayCountry(ULocale displayLocale) {
        return ULocale.getDisplayCountryInternal(this.localeID, displayLocale.localeID);
    }

    public static String getDisplayCountry(String localeID, String displayLocaleID) {
        return ULocale.getDisplayCountryInternal(localeID, ULocale.getName(displayLocaleID));
    }

    public static String getDisplayCountry(String localeID, ULocale displayLocale) {
        return ULocale.getDisplayCountryInternal(localeID, displayLocale.localeID);
    }

    private static String getDisplayCountryInternal(String localeID, String displayLocaleID) {
        return ULocale.getTableString("Countries", null, new IDParser(localeID).getCountry(), displayLocaleID);
    }

    public String getDisplayVariant() {
        return ULocale.getDisplayVariantInternal(this.localeID, ULocale.getDefault().localeID);
    }

    public String getDisplayVariant(ULocale displayLocale) {
        return ULocale.getDisplayVariantInternal(this.localeID, displayLocale.localeID);
    }

    public static String getDisplayVariant(String localeID, String displayLocaleID) {
        return ULocale.getDisplayVariantInternal(localeID, ULocale.getName(displayLocaleID));
    }

    public static String getDisplayVariant(String localeID, ULocale displayLocale) {
        return ULocale.getDisplayVariantInternal(localeID, displayLocale.localeID);
    }

    private static String getDisplayVariantInternal(String localeID, String displayLocaleID) {
        return ULocale.getTableString("Variants", null, new IDParser(localeID).getVariant(), displayLocaleID);
    }

    public static String getDisplayKeyword(String keyword) {
        return ULocale.getDisplayKeywordInternal(keyword, ULocale.getDefault().localeID);
    }

    public static String getDisplayKeyword(String keyword, String displayLocaleID) {
        return ULocale.getDisplayKeywordInternal(keyword, ULocale.getName(displayLocaleID));
    }

    public static String getDisplayKeyword(String keyword, ULocale displayLocale) {
        return ULocale.getDisplayKeywordInternal(keyword, displayLocale.localeID);
    }

    private static String getDisplayKeywordInternal(String keyword, String displayLocaleID) {
        return ULocale.getTableString("Keys", null, keyword.trim().toLowerCase(), displayLocaleID);
    }

    public String getDisplayKeywordValue(String keyword) {
        return ULocale.getDisplayKeywordValueInternal(this.localeID, keyword, ULocale.getDefault().localeID);
    }

    public String getDisplayKeywordValue(String keyword, ULocale displayLocale) {
        return ULocale.getDisplayKeywordValueInternal(this.localeID, keyword, displayLocale.localeID);
    }

    public static String getDisplayKeywordValue(String localeID, String keyword, String displayLocaleID) {
        return ULocale.getDisplayKeywordValueInternal(localeID, keyword, ULocale.getName(displayLocaleID));
    }

    public static String getDisplayKeywordValue(String localeID, String keyword, ULocale displayLocale) {
        return ULocale.getDisplayKeywordValueInternal(localeID, keyword, displayLocale.localeID);
    }

    private static String getDisplayKeywordValueInternal(String localeID, String keyword, String displayLocaleID) {
        keyword = keyword.trim().toLowerCase();
        String value = new IDParser(localeID).getKeywordValue(keyword);
        return ULocale.getTableString("Types", keyword, value, displayLocaleID);
    }

    public String getDisplayName() {
        return ULocale.getDisplayNameInternal(this.localeID, ULocale.getDefault().localeID);
    }

    public String getDisplayName(ULocale displayLocale) {
        return ULocale.getDisplayNameInternal(this.localeID, displayLocale.localeID);
    }

    public static String getDisplayName(String localeID, String displayLocaleID) {
        return ULocale.getDisplayNameInternal(localeID, ULocale.getName(displayLocaleID));
    }

    public static String getDisplayName(String localeID, ULocale displayLocale) {
        return ULocale.getDisplayNameInternal(localeID, displayLocale.localeID);
    }

    private static String getDisplayNameInternal(String localeID, String displayLocaleID) {
        String[] tableNames = new String[]{"Languages", "Scripts", "Countries", "Variants"};
        ICUResourceBundle bundle = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt30b", displayLocaleID);
        StringBuffer buf = new StringBuffer();
        IDParser parser = new IDParser(localeID);
        String[] names = parser.getLanguageScriptCountryVariant();
        boolean haveLanguage = names[0].length() > 0;
        boolean openParen = false;
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            if (name.length() <= 0) continue;
            name = ULocale.getTableString(tableNames[i], null, name, bundle);
            if (buf.length() > 0) {
                if (haveLanguage & !openParen) {
                    buf.append(" (");
                    openParen = true;
                } else {
                    buf.append(", ");
                }
            }
            buf.append(name);
        }
        Map m = parser.getKeywordMap();
        if (!m.isEmpty()) {
            Iterator keys = m.entrySet().iterator();
            while (keys.hasNext()) {
                if (buf.length() > 0) {
                    if (haveLanguage & !openParen) {
                        buf.append(" (");
                        openParen = true;
                    } else {
                        buf.append(", ");
                    }
                }
                Map.Entry e = keys.next();
                String key = (String)e.getKey();
                String val = (String)e.getValue();
                buf.append(ULocale.getTableString("Keys", null, key, bundle));
                buf.append("=");
                buf.append(ULocale.getTableString("Types", key, val, bundle));
            }
        }
        if (openParen) {
            buf.append(")");
        }
        return buf.toString();
    }

    static {
        PRC = CHINA = new ULocale("zh_Hans_CN", Locale.CHINA);
        TAIWAN = new ULocale("zh_Hant_TW", Locale.TAIWAN);
        UK = new ULocale("en_GB", Locale.UK);
        US = new ULocale("en_US", Locale.US);
        CANADA = new ULocale("en_CA", Locale.CANADA);
        CANADA_FRENCH = new ULocale("fr_CA", Locale.CANADA_FRENCH);
        ROOT = new ULocale(EMPTY_STRING, null);
        ACTUAL_LOCALE = new Type(0);
        VALID_LOCALE = new Type(1);
    }

    public static final class Type {
        private int localeType;

        private Type(int type) {
            this.localeType = type;
        }
    }

    private static final class IDParser {
        private char[] id;
        private int index;
        private char[] buffer;
        private int blen;
        private boolean canonicalize;
        private boolean hadCountry;
        Map keywords;
        String baseName;
        private static final char KEYWORD_SEPARATOR = '@';
        private static final char HYPHEN = '-';
        private static final char KEYWORD_ASSIGN = '=';
        private static final char COMMA = ',';
        private static final char ITEM_SEPARATOR = ';';
        private static final char DOT = '.';
        private static final char DONE = '\uffff';

        private IDParser(String localeID) {
            this(localeID, false);
        }

        private IDParser(String localeID, boolean canonicalize) {
            this.id = localeID.toCharArray();
            this.index = 0;
            this.buffer = new char[this.id.length + 5];
            this.blen = 0;
            this.canonicalize = canonicalize;
        }

        private void reset() {
            this.blen = 0;
            this.index = 0;
        }

        private void append(char c) {
            try {
                this.buffer[this.blen] = c;
            }
            catch (IndexOutOfBoundsException e) {
                if (this.buffer.length > 512) {
                    throw e;
                }
                char[] nbuffer = new char[this.buffer.length * 2];
                System.arraycopy(this.buffer, 0, nbuffer, 0, this.buffer.length);
                nbuffer[this.blen] = c;
                this.buffer = nbuffer;
            }
            ++this.blen;
        }

        private void addSeparator() {
            this.append('_');
        }

        private String getString(int start) {
            if (start == this.blen) {
                return ULocale.EMPTY_STRING;
            }
            return new String(this.buffer, start, this.blen - start);
        }

        private void set(int pos, String s) {
            this.blen = pos;
            this.append(s);
        }

        private void append(String s) {
            for (int i = 0; i < s.length(); ++i) {
                this.append(s.charAt(i));
            }
        }

        private char next() {
            if (this.index == this.id.length) {
                ++this.index;
                return '\uffff';
            }
            return this.id[this.index++];
        }

        private void skipUntilTerminatorOrIDSeparator() {
            while (!this.isTerminatorOrIDSeparator(this.next())) {
            }
            --this.index;
        }

        private boolean atTerminator() {
            return this.index >= this.id.length || this.isTerminator(this.id[this.index]);
        }

        private boolean isIDSeparator(char c) {
            return c == '_' || c == '-';
        }

        private boolean isTerminator(char c) {
            return c == '@' || c == '\uffff' || c == '.';
        }

        private boolean isTerminatorOrIDSeparator(char c) {
            return c == '@' || c == '_' || c == '-' || c == '\uffff' || c == '.';
        }

        private boolean haveExperimentalLanguagePrefix() {
            char c;
            if (this.id.length > 2 && ((c = this.id[1]) == '-' || c == '_')) {
                c = this.id[0];
                return c == 'x' || c == 'X' || c == 'i' || c == 'I';
            }
            return false;
        }

        private boolean haveKeywordAssign() {
            for (int i = this.index; i < this.id.length; ++i) {
                if (this.id[i] != '=') continue;
                return true;
            }
            return false;
        }

        private int parseLanguage() {
            char c;
            if (this.haveExperimentalLanguagePrefix()) {
                this.append(Character.toLowerCase(this.id[0]));
                this.append('-');
                this.index = 2;
            }
            while (!this.isTerminatorOrIDSeparator(c = this.next())) {
                this.append(Character.toLowerCase(c));
            }
            --this.index;
            if (this.blen == 3) {
                ULocale.initLanguageTables();
                String lang = this.getString(0);
                int offset = ULocale.findIndex(_languages3, lang);
                if (offset >= 0) {
                    this.set(0, _languages[offset]);
                } else {
                    offset = ULocale.findIndex(_obsoleteLanguages3, lang);
                    if (offset >= 0) {
                        this.set(0, _obsoleteLanguages[offset]);
                    }
                }
            }
            return 0;
        }

        private void skipLanguage() {
            if (this.haveExperimentalLanguagePrefix()) {
                this.index = 2;
            }
            this.skipUntilTerminatorOrIDSeparator();
        }

        private int parseScript() {
            if (!this.atTerminator()) {
                char c;
                int oldIndex = this.index++;
                int oldBlen = this.blen;
                while (!this.isTerminatorOrIDSeparator(c = this.next())) {
                    if (this.blen == oldBlen) {
                        this.addSeparator();
                        this.append(Character.toUpperCase(c));
                        continue;
                    }
                    this.append(Character.toLowerCase(c));
                }
                --this.index;
                if (this.index - oldIndex != 5) {
                    this.index = oldIndex;
                    this.blen = oldBlen;
                } else {
                    ++oldBlen;
                }
                return oldBlen;
            }
            return this.blen;
        }

        private void skipScript() {
            if (!this.atTerminator()) {
                int oldIndex = this.index++;
                this.skipUntilTerminatorOrIDSeparator();
                if (this.index - oldIndex != 5) {
                    this.index = oldIndex;
                }
            }
        }

        private int parseCountry() {
            if (!this.atTerminator()) {
                char c;
                ++this.index;
                int oldBlen = this.blen;
                while (!this.isTerminatorOrIDSeparator(c = this.next())) {
                    if (oldBlen == this.blen) {
                        this.hadCountry = true;
                        this.addSeparator();
                        ++oldBlen;
                    }
                    this.append(Character.toUpperCase(c));
                }
                --this.index;
                if (this.blen - oldBlen == 3) {
                    ULocale.initCountryTables();
                    int offset = ULocale.findIndex(_countries3, this.getString(oldBlen));
                    if (offset >= 0) {
                        this.set(oldBlen, _countries[offset]);
                    } else {
                        offset = ULocale.findIndex(_obsoleteCountries3, this.getString(oldBlen));
                        if (offset >= 0) {
                            this.set(oldBlen, _obsoleteCountries[offset]);
                        }
                    }
                }
                return oldBlen;
            }
            return this.blen;
        }

        private void skipCountry() {
            if (!this.atTerminator()) {
                ++this.index;
                this.skipUntilTerminatorOrIDSeparator();
            }
        }

        private int parseVariant() {
            char c;
            int oldBlen = this.blen;
            boolean start = true;
            boolean needSeparator = true;
            boolean skipping = false;
            while ((c = this.next()) != '\uffff') {
                if (c == '.') {
                    start = false;
                    skipping = true;
                    continue;
                }
                if (c == '@') {
                    if (this.haveKeywordAssign()) break;
                    skipping = false;
                    start = false;
                    needSeparator = true;
                    continue;
                }
                if (start) {
                    start = false;
                    continue;
                }
                if (skipping) continue;
                if (needSeparator) {
                    boolean incOldBlen = this.blen == oldBlen;
                    needSeparator = false;
                    if (incOldBlen && !this.hadCountry) {
                        this.addSeparator();
                        ++oldBlen;
                    }
                    this.addSeparator();
                    if (incOldBlen) {
                        ++oldBlen;
                    }
                }
                if ((c = Character.toUpperCase(c)) == '-' || c == ',') {
                    c = '_';
                }
                this.append(c);
            }
            --this.index;
            return oldBlen;
        }

        public String getLanguage() {
            this.reset();
            return this.getString(this.parseLanguage());
        }

        public String getScript() {
            this.reset();
            this.skipLanguage();
            return this.getString(this.parseScript());
        }

        public String getCountry() {
            this.reset();
            this.skipLanguage();
            this.skipScript();
            return this.getString(this.parseCountry());
        }

        public String getVariant() {
            this.reset();
            this.skipLanguage();
            this.skipScript();
            this.skipCountry();
            return this.getString(this.parseVariant());
        }

        public String[] getLanguageScriptCountryVariant() {
            this.reset();
            return new String[]{this.getString(this.parseLanguage()), this.getString(this.parseScript()), this.getString(this.parseCountry()), this.getString(this.parseVariant())};
        }

        public void setBaseName(String baseName) {
            this.baseName = baseName;
        }

        public void parseBaseName() {
            if (this.baseName != null) {
                this.set(0, this.baseName);
            } else {
                this.reset();
                this.parseLanguage();
                this.parseScript();
                this.parseCountry();
                this.parseVariant();
                if (this.blen > 1 && this.buffer[this.blen - 1] == '_') {
                    --this.blen;
                }
            }
        }

        public String getBaseName() {
            if (this.baseName != null) {
                return this.baseName;
            }
            this.parseBaseName();
            return this.getString(0);
        }

        public String getName() {
            this.parseBaseName();
            this.parseKeywords();
            return this.getString(0);
        }

        private boolean setToKeywordStart() {
            for (int i = this.index; i < this.id.length; ++i) {
                if (this.id[i] != '@') continue;
                if (this.canonicalize) {
                    for (int j = ++i; j < this.id.length; ++j) {
                        if (this.id[j] != '=') continue;
                        this.index = i;
                        return true;
                    }
                    break;
                }
                if (++i >= this.id.length) break;
                this.index = i;
                return true;
            }
            return false;
        }

        private static boolean isDoneOrKeywordAssign(char c) {
            return c == '\uffff' || c == '=';
        }

        private static boolean isDoneOrItemSeparator(char c) {
            return c == '\uffff' || c == ';';
        }

        private String getKeyword() {
            int start = this.index;
            while (!IDParser.isDoneOrKeywordAssign(this.next())) {
            }
            --this.index;
            return new String(this.id, start, this.index - start).trim().toLowerCase();
        }

        private String getValue() {
            int start = this.index;
            while (!IDParser.isDoneOrItemSeparator(this.next())) {
            }
            --this.index;
            return new String(this.id, start, this.index - start).trim();
        }

        private Comparator getKeyComparator() {
            Comparator comp = new Comparator(){

                public int compare(Object lhs, Object rhs) {
                    return ((String)lhs).compareTo(rhs);
                }
            };
            return comp;
        }

        private Map getKeywordMap() {
            block6: {
                TreeMap<String, String> m;
                block7: {
                    String key;
                    if (this.keywords != null) break block6;
                    m = null;
                    if (!this.setToKeywordStart()) break block7;
                    while ((key = this.getKeyword()).length() != 0) {
                        block9: {
                            String value;
                            block11: {
                                block10: {
                                    block8: {
                                        char c = this.next();
                                        if (c == '=') break block8;
                                        if (c == '\uffff') {
                                            break;
                                        }
                                        break block9;
                                    }
                                    value = this.getValue();
                                    if (value.length() == 0) break block9;
                                    if (m != null) break block10;
                                    m = new TreeMap<String, String>(this.getKeyComparator());
                                    break block11;
                                }
                                if (m.containsKey(key)) break block9;
                            }
                            m.put(key, value);
                        }
                        if (this.next() == ';') continue;
                    }
                }
                this.keywords = m != null ? m : Collections.EMPTY_MAP;
            }
            return this.keywords;
        }

        private int parseKeywords() {
            int oldBlen = this.blen;
            Map m = this.getKeywordMap();
            if (!m.isEmpty()) {
                Iterator iter = m.entrySet().iterator();
                boolean first = true;
                while (iter.hasNext()) {
                    this.append(first ? (char)'@' : ';');
                    first = false;
                    Map.Entry e = iter.next();
                    this.append((String)e.getKey());
                    this.append('=');
                    this.append((String)e.getValue());
                }
                if (this.blen != oldBlen) {
                    ++oldBlen;
                }
            }
            return oldBlen;
        }

        public Iterator getKeywords() {
            Map m = this.getKeywordMap();
            return m.isEmpty() ? null : m.keySet().iterator();
        }

        public String getKeywordValue(String keywordName) {
            Map m = this.getKeywordMap();
            return m.isEmpty() ? null : (String)m.get(keywordName.trim().toLowerCase());
        }

        public void defaultKeywordValue(String keywordName, String value) {
            this.setKeywordValue(keywordName, value, false);
        }

        public void setKeywordValue(String keywordName, String value) {
            this.setKeywordValue(keywordName, value, true);
        }

        private void setKeywordValue(String keywordName, String value, boolean reset) {
            if (keywordName == null) {
                if (reset) {
                    this.keywords = Collections.EMPTY_MAP;
                }
            } else {
                if ((keywordName = keywordName.trim().toLowerCase()).length() == 0) {
                    throw new IllegalArgumentException("keyword must not be empty");
                }
                if ((value = value.trim()).length() == 0) {
                    throw new IllegalArgumentException("value must not be empty");
                }
                Map m = this.getKeywordMap();
                if (m.isEmpty()) {
                    if (value != null) {
                        this.keywords = new TreeMap(this.getKeyComparator());
                        this.keywords.put(keywordName, value.trim());
                    }
                } else if (reset || !m.containsKey(keywordName)) {
                    if (value != null) {
                        m.put(keywordName, value);
                    } else {
                        m.remove(keywordName);
                        if (m.isEmpty()) {
                            this.keywords = Collections.EMPTY_MAP;
                        }
                    }
                }
            }
        }
    }
}

