/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.Transform;
import net.sf.saxon.dom.DocumentWrapper;
import net.sf.saxon.xpath.DynamicError;
import net.sf.saxon.xpath.XPathException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class DOMTransform
extends Transform {
    public List preprocess(List list) throws XPathException {
        try {
            ArrayList<DocumentWrapper> arrayList = new ArrayList<DocumentWrapper>(list.size());
            int n = 0;
            while (n < list.size()) {
                SAXSource sAXSource = (SAXSource)list.get(n);
                System.setProperty("javax.xml.parser.DocumentBuilderFactory", "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(sAXSource.getInputSource());
                DocumentWrapper documentWrapper = new DocumentWrapper(document, sAXSource.getSystemId(), this.getConfiguration());
                arrayList.add(documentWrapper);
                ++n;
            }
            return arrayList;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new DynamicError(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new DynamicError(sAXException);
        }
        catch (IOException iOException) {
            throw new DynamicError(iOException);
        }
    }

    public static void main(String[] stringArray) {
        new DOMTransform().doMain(stringArray, "DOMTransform");
    }
}

