/*
 * Decompiled with CFR 0.152.
 */
package com.isogen.indexhelper;

import com.isogen.i18nsupport.I18nUtil;
import com.isogen.i18nsupport.I18nUtilError;
import com.isogen.indexhelper.IndexHelperException;
import com.isogen.indexhelper.IndexRuleSet;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class IndexGroup {
    public String key;
    public String label;
    public String groupSortKey;
    public Vector members;
    public IndexRuleSet indexConfiguration;
    public String lastMember;

    public IndexGroup(IndexRuleSet parent, Element igElem) throws IndexHelperException {
        block15: {
            this.members = new Vector();
            this.lastMember = null;
            this.indexConfiguration = parent;
            try {
                Element gkElem = I18nUtil.getElement(igElem, "group_key");
                this.key = I18nUtil.getElementContent(gkElem);
                if (this.key.equals("")) {
                    throw new IndexHelperException("Null value for <group_key> element in <term_group) for language '" + parent.getLanguage() + "'");
                }
                this.label = this.key;
                this.groupSortKey = this.key;
                try {
                    Element glElem = I18nUtil.getElement(igElem, "group_label");
                    this.label = I18nUtil.getElementContent(glElem);
                    if (this.key.equals("")) {
                        throw new IndexHelperException("Null value for <group_label> element in <term_group) for language '" + parent.getLanguage() + "'");
                    }
                }
                catch (I18nUtilError glElem) {
                    // empty catch block
                }
                if (this.indexConfiguration.sortGroups == 1) {
                    this.groupSortKey = this.label;
                }
                Element groupMembersElem = I18nUtil.getElement(igElem, "group_members");
                if (parent.sortStrategy == 1) {
                    NodeList memberElems = groupMembersElem.getElementsByTagName("char_or_seq");
                    if (memberElems.getLength() == 0 && this.indexConfiguration.sortStrategy == 1) {
                        throw new IndexHelperException("No char_or_seq elements in group_members element when grouping strategy is 'by members'");
                    }
                    int i = 0;
                    while (i < memberElems.getLength()) {
                        String memStr = I18nUtil.getElementContent((Element)memberElems.item(i));
                        if (!memStr.equals("")) {
                            this.members.add(memStr);
                        } else {
                            System.err.println("WARNING: IndexRuleSet - Empty <char_or_seq> element in <group_members> with key '" + this.key + "', language '" + parent.getLanguage() + "'");
                        }
                        ++i;
                    }
                    break block15;
                }
                try {
                    Element charSetElem = I18nUtil.getElement(igElem, "char_or_seq");
                    this.lastMember = I18nUtil.getElementContent(charSetElem);
                    if (this.lastMember.equals("")) {
                        throw new IndexHelperException("Null value for <char_or_seq> element in <last.member> for language '" + parent.getLanguage() + "'");
                    }
                }
                catch (I18nUtilError i18nUtilError) {}
            }
            catch (I18nUtilError e) {
                throw new IndexHelperException(e.getMessage());
            }
        }
    }

    public String toString() {
        String outStr = "";
        outStr = String.valueOf(outStr) + "\n\t\tKey: '" + I18nUtil.escapeUnicodeString(this.key) + "'";
        outStr = String.valueOf(outStr) + "\n\t\tLabel: '" + I18nUtil.escapeUnicodeString(this.label) + "'";
        outStr = String.valueOf(outStr) + "\n\t\tMembers:";
        if (this.lastMember != null) {
            outStr = String.valueOf(outStr) + "\n\t\t\t LastMember='" + I18nUtil.escapeUnicodeString(this.lastMember) + "'";
        } else {
            int i = 0;
            while (i < this.members.size()) {
                outStr = String.valueOf(outStr) + "\n\t\t\t'" + I18nUtil.escapeUnicodeString((String)this.members.elementAt(i)) + "'";
                ++i;
            }
        }
        return outStr;
    }
}

