/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.io.PrintStream;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMLocator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.style.StandardNames;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trace.InstructionInfoProvider;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.xpath.DynamicError;
import net.sf.saxon.xpath.XPathException;
import org.xml.sax.SAXException;

public class StandardErrorListener
implements ErrorListener {
    private int recoveryPolicy = 1;
    private int warningCount = 0;
    protected transient PrintStream errorOutput = System.err;

    public StandardErrorListener makeAnother() {
        return new StandardErrorListener();
    }

    public void setErrorOutput(PrintStream printStream) {
        this.errorOutput = printStream;
    }

    public PrintStream getErrorOutput() {
        return this.errorOutput;
    }

    public void setRecoveryPolicy(int n) {
        this.recoveryPolicy = n;
    }

    public void warning(TransformerException transformerException) throws TransformerException {
        if (this.recoveryPolicy == 0) {
            return;
        }
        if (this.errorOutput == null) {
            this.errorOutput = System.err;
        }
        String string = "";
        if (transformerException.getLocator() != null) {
            string = StandardErrorListener.getLocationMessage(transformerException) + "\n  ";
        }
        string = string + StandardErrorListener.wordWrap(StandardErrorListener.getExpandedMessage(transformerException));
        if (transformerException instanceof ValidationException) {
            this.errorOutput.println("Validation error " + string);
        } else if (this.recoveryPolicy == 1) {
            this.errorOutput.println("Warning: " + string);
            ++this.warningCount;
            if (this.warningCount > 25) {
                this.errorOutput.println("No more warnings will be displayed");
                this.recoveryPolicy = 0;
                this.warningCount = 0;
            }
        } else {
            this.errorOutput.println("Recoverable error");
            this.errorOutput.println(string);
            this.errorOutput.println("Processing terminated because error recovery is disabled");
            throw new DynamicError(transformerException);
        }
    }

    public void error(TransformerException transformerException) throws TransformerException {
        if (this.errorOutput == null) {
            this.errorOutput = System.err;
        }
        String string = (transformerException instanceof ValidationException ? "Validation error " : "Error ") + StandardErrorListener.getLocationMessage(transformerException) + "\n  " + StandardErrorListener.wordWrap(StandardErrorListener.getExpandedMessage(transformerException));
        this.errorOutput.println(string);
    }

    public void fatalError(TransformerException transformerException) throws TransformerException {
        this.error(transformerException);
        throw transformerException;
    }

    public static String getLocationMessage(TransformerException transformerException) {
        SourceLocator sourceLocator = transformerException.getLocator();
        if (sourceLocator == null) {
            while (true) {
                if (transformerException.getException() instanceof TransformerException) {
                    transformerException = (TransformerException)transformerException.getException();
                    continue;
                }
                if (!(transformerException.getCause() instanceof TransformerException)) break;
                transformerException = (TransformerException)transformerException.getCause();
            }
            return "";
        }
        XPathContext xPathContext = null;
        if (transformerException instanceof DynamicError) {
            xPathContext = ((DynamicError)transformerException).getXPathContext();
        }
        return StandardErrorListener.getLocationMessage(sourceLocator, xPathContext);
    }

    private static String getLocationMessage(SourceLocator sourceLocator, XPathContext xPathContext) {
        String string = "";
        String string2 = null;
        int n = -1;
        if (sourceLocator instanceof DOMLocator) {
            string = string + "at " + ((DOMLocator)sourceLocator).getOriginatingNode().getNodeName() + ' ';
        } else if (sourceLocator instanceof InstructionInfoProvider) {
            String string3 = StandardErrorListener.getInstructionName((InstructionInfoProvider)((Object)sourceLocator), xPathContext);
            if (!"".equals(string3)) {
                string = string + "at " + string3 + ' ';
            }
            string2 = ((InstructionInfoProvider)((Object)sourceLocator)).getInstructionInfo().getSystemId();
            n = ((InstructionInfoProvider)((Object)sourceLocator)).getInstructionInfo().getLineNumber();
        }
        if (n == -1) {
            n = sourceLocator.getLineNumber();
        }
        if (n != -1) {
            string = string + "on line " + n + ' ';
        }
        if (sourceLocator.getColumnNumber() != -1) {
            string = string + "column " + sourceLocator.getColumnNumber() + ' ';
        }
        if (string2 == null) {
            string2 = sourceLocator.getSystemId();
        }
        if (string2 != null) {
            string = string + "of " + string2 + ':';
        }
        return string;
    }

    public static String getExpandedMessage(TransformerException transformerException) {
        Object object;
        Object object2 = "";
        if (transformerException instanceof XPathException && (object = ((XPathException)transformerException).getErrorCode()) != null) {
            object2 = object;
        }
        object = transformerException;
        while (object != null) {
            String string = ((Throwable)object).getMessage();
            if (string == null) {
                string = "";
            }
            if (!"TRaX Transform Exception".equals(string) && !((String)object2).endsWith(string)) {
                if (!"".equals(object2)) {
                    object2 = (String)object2 + ": ";
                }
                object2 = (String)object2 + ((Throwable)object).getMessage();
            }
            if (object instanceof TransformerException) {
                object = ((TransformerException)object).getException();
                continue;
            }
            if (!(object instanceof SAXException)) break;
            object = ((SAXException)object).getException();
        }
        return object2;
    }

    private static String getInstructionName(InstructionInfoProvider instructionInfoProvider, XPathContext xPathContext) {
        if (xPathContext == null) {
            return "";
        }
        try {
            InstructionInfo instructionInfo = instructionInfoProvider.getInstructionInfo();
            int n = instructionInfo.getConstructType();
            if (n < 1024 && n != 149 && n != 181) {
                return StandardNames.getDisplayName(n);
            }
            switch (n) {
                case 2006: {
                    int n2 = instructionInfo.getObjectNameCode();
                    String string = "element constructor";
                    if (xPathContext != null) {
                        string = string + " <" + xPathContext.getController().getNamePool().getDisplayName(n2) + '>';
                    }
                    return string;
                }
                case 2007: {
                    int n3 = instructionInfo.getObjectNameCode();
                    String string = "attribute constructor";
                    if (xPathContext != null) {
                        string = string + ' ' + xPathContext.getController().getNamePool().getDisplayName(n3) + "=\"{...}\"";
                    }
                    return string;
                }
                case 149: {
                    int n4 = instructionInfo.getObjectNameCode();
                    String string = "function";
                    if (xPathContext != null) {
                        string = string + ' ' + xPathContext.getController().getNamePool().getDisplayName(n4) + "()";
                    }
                    return string;
                }
                case 181: {
                    int n5 = instructionInfo.getObjectNameCode();
                    String string = "template";
                    if (xPathContext != null && n5 != -1) {
                        string = string + " name=\"" + xPathContext.getController().getNamePool().getDisplayName(n5) + '\"';
                    }
                    return string;
                }
            }
            return "";
        }
        catch (Exception exception) {
            return "";
        }
    }

    private static String wordWrap(String string) {
        int n = string.indexOf(10);
        if (n < 0) {
            n = string.length();
        }
        if (n > 100) {
            int n2 = 90;
            while (string.charAt(n2) != ' ' && n2 > 0) {
                --n2;
            }
            if (n2 > 10) {
                return string.substring(0, n2) + "\n  " + StandardErrorListener.wordWrap(string.substring(n2 + 1));
            }
            return string;
        }
        return string;
    }
}

