/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.xpath.StaticError;
import net.sf.saxon.xpath.XPathException;

public final class ItemChecker
extends UnaryExpression
implements MappingFunction {
    private ItemType requiredItemType;
    private RoleLocator role;
    private String errorCode;

    public ItemChecker(Expression expression, ItemType itemType, RoleLocator roleLocator) {
        super(expression);
        this.requiredItemType = itemType;
        this.role = roleLocator;
        this.adoptChildExpression(expression);
    }

    public void setErrorCode(String string) {
        this.errorCode = string;
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.operand = this.operand.simplify(staticContext);
        if (this.requiredItemType instanceof AnyItemType) {
            return this.operand;
        }
        return this;
    }

    public Expression analyze(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.operand = this.operand.analyze(staticContext, itemType);
        ItemType itemType2 = this.operand.getItemType();
        int n = Type.relationship(this.requiredItemType, itemType2);
        if (n == 0 || n == 1) {
            return this.operand;
        }
        if (n == 4) {
            String string = "Required type of " + this.role.getMessage() + " is " + this.requiredItemType.toString(staticContext.getNamePool()) + "; supplied value has type " + this.operand.getItemType().toString(staticContext.getNamePool());
            StaticError staticError = new StaticError(string);
            staticError.setLocator(this);
            staticError.setIsTypeError(true);
            throw staticError;
        }
        return this;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.operand.iterate(xPathContext);
        return new MappingIterator(sequenceIterator, this, null, xPathContext);
    }

    public Object map(Item item, XPathContext xPathContext, Object object) throws XPathException {
        this.testConformance(item, (XPathContext)object);
        return item;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Item item = this.operand.evaluateItem(xPathContext);
        if (item == null) {
            return null;
        }
        this.testConformance(item, xPathContext);
        return item;
    }

    private void testConformance(Item item, XPathContext xPathContext) throws XPathException {
        if (!this.requiredItemType.matchesItem(item)) {
            String string = "Required type of " + this.role.getMessage() + " is " + this.requiredItemType.toString(xPathContext.getController().getNamePool()) + "; supplied value has type " + Type.displayTypeName(item);
            if ("XP0050".equals(this.errorCode)) {
                this.dynamicError(string, this.errorCode, xPathContext);
            } else {
                this.typeError(string, xPathContext);
            }
        }
    }

    public ItemType getItemType() {
        return this.requiredItemType;
    }

    public boolean equals(Object object) {
        return super.equals(object) && this.requiredItemType == ((ItemChecker)object).requiredItemType;
    }

    protected String displayOperator(NamePool namePool) {
        return "treat as " + this.requiredItemType.toString(namePool);
    }
}

