/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.PrintStream;
import java.util.Iterator;
import net.sf.saxon.Controller;
import net.sf.saxon.event.NoOpenStartTagException;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.instruct.DummyNamespaceResolver;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.Validation;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.xpath.DynamicError;
import net.sf.saxon.xpath.XPathException;

public class CopyOf
extends Instruction {
    private Expression select;
    private boolean copyNamespaces;
    private int validation;
    private SchemaType schemaType;
    private boolean requireDocumentOrElement = false;

    public CopyOf(Expression expression, boolean bl, int n, SchemaType schemaType) {
        this.select = expression;
        this.copyNamespaces = bl;
        this.validation = n;
        this.schemaType = schemaType;
    }

    public int getInstructionNameCode() {
        return 140;
    }

    public void setRequireDocumentOrElement(boolean bl) {
        this.requireDocumentOrElement = bl;
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        Item item;
        Controller controller = xPathContext.getController();
        SequenceReceiver sequenceReceiver = xPathContext.getReceiver();
        int n = this.copyNamespaces ? 2 : 0;
        SequenceIterator sequenceIterator = this.select.iterate(xPathContext);
        block13: while ((item = sequenceIterator.next()) != null) {
            if (item instanceof NodeInfo) {
                Object object;
                NodeInfo nodeInfo = (NodeInfo)item;
                int n2 = nodeInfo.getNodeKind();
                if (this.requireDocumentOrElement && n2 != 1 && n2 != 9) {
                    object = new DynamicError("Operand of validate expression must be a document or element node");
                    ((DynamicError)object).setXPathContext(xPathContext);
                    ((XPathException)object).setErrorCode("XQ0030");
                    throw object;
                }
                switch (n2) {
                    case 1: {
                        object = controller.getConfiguration().getElementValidator(sequenceReceiver, nodeInfo.getNameCode(), this.locationId, this.schemaType, this.validation, controller.getNamePool());
                        nodeInfo.copy((Receiver)object, n, true, this.locationId);
                        continue block13;
                    }
                    case 2: {
                        DynamicError dynamicError;
                        try {
                            CopyOf.copyAttribute(nodeInfo, this.schemaType, this.validation, this.locationId, xPathContext);
                        }
                        catch (NoOpenStartTagException noOpenStartTagException) {
                            dynamicError = new DynamicError(noOpenStartTagException.getMessage());
                            dynamicError.setXPathContext(xPathContext);
                            dynamicError.setErrorCode(noOpenStartTagException.getErrorCode());
                            xPathContext.getController().recoverableError(dynamicError);
                        }
                        continue block13;
                    }
                    case 3: {
                        sequenceReceiver.characters(nodeInfo.getStringValue(), this.locationId, 0);
                        continue block13;
                    }
                    case 7: {
                        sequenceReceiver.processingInstruction(nodeInfo.getDisplayName(), nodeInfo.getStringValue(), this.locationId, 0);
                        continue block13;
                    }
                    case 8: {
                        sequenceReceiver.comment(nodeInfo.getStringValue(), this.locationId, 0);
                        continue block13;
                    }
                    case 13: {
                        DynamicError dynamicError;
                        try {
                            nodeInfo.copy(sequenceReceiver, 0, false, this.locationId);
                        }
                        catch (NoOpenStartTagException noOpenStartTagException) {
                            dynamicError = new DynamicError(noOpenStartTagException.getMessage());
                            dynamicError.setXPathContext(xPathContext);
                            dynamicError.setErrorCode(noOpenStartTagException.getErrorCode());
                            xPathContext.getController().recoverableError(dynamicError);
                        }
                        continue block13;
                    }
                    case 9: {
                        Receiver receiver = controller.getConfiguration().getDocumentValidator(sequenceReceiver, nodeInfo.getBaseURI(), controller.getNamePool(), this.validation);
                        receiver.setConfiguration(controller.getConfiguration());
                        receiver.startDocument(0);
                        nodeInfo.copy(receiver, n, true, this.locationId);
                        receiver.endDocument();
                        continue block13;
                    }
                }
                throw new IllegalArgumentException("Unknown node kind " + nodeInfo.getNodeKind());
            }
            sequenceReceiver.append(item, this.locationId);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static void copyAttribute(NodeInfo nodeInfo, SchemaType schemaType, int n, int n2, XPathContext xPathContext) throws XPathException {
        int n3 = nodeInfo.getNameCode();
        int n4 = -1;
        int n5 = 0;
        String string = nodeInfo.getStringValue();
        if (schemaType != null) {
            if (!(schemaType instanceof SimpleType)) {
                DynamicError dynamicError = new DynamicError("Cannot validate an attribute against a complex type");
                dynamicError.setXPathContext(xPathContext);
                dynamicError.setErrorCode("XT1530");
                throw dynamicError;
            }
            try {
                ((SimpleType)schemaType).validateContent(string, DummyNamespaceResolver.getInstance());
                if (((SimpleType)schemaType).isNamespaceSensitive()) {
                    n5 |= 0x200;
                }
                n4 = schemaType.getFingerprint();
            }
            catch (ValidationException validationException) {
                throw new ValidationException("Attribute being copied does not match the required type. " + validationException.getMessage());
            }
        } else if (n == 1 || n == 2) {
            long l = xPathContext.getController().getConfiguration().validateAttribute(n3, string, n);
            n4 = (int)(l & 0xFFFFFFFFFFFFFFFFL);
            n5 |= (int)(l >> 32);
        }
        xPathContext.getReceiver().attribute(n3, n4, string, n2, n5);
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.select = this.select.simplify(staticContext);
        return this;
    }

    public ItemType getItemType() {
        return this.select.getItemType();
    }

    public int getCardinality() {
        return this.select.getCardinality();
    }

    public int getDependencies() {
        return this.select.getDependencies();
    }

    protected void promoteInst(PromotionOffer promotionOffer) throws XPathException {
        this.select = this.select.promote(promotionOffer);
    }

    public Expression analyze(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.select = this.select.analyze(staticContext, itemType);
        return this;
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        printStream.println(ExpressionTool.indent(n) + "copyOf " + "validation=" + Validation.toString(this.validation));
        this.select.display(n + 1, namePool, printStream);
    }

    public Iterator iterateSubExpressions() {
        return new MonoIterator(this.select);
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        return super.evaluateItem(xPathContext);
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        return super.effectiveBooleanValue(xPathContext);
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        Controller controller = xPathContext.getController();
        XPathContextMinor xPathContextMinor = xPathContext.newMinorContext();
        xPathContextMinor.setOrigin(this);
        SequenceOutputter sequenceOutputter = new SequenceOutputter();
        sequenceOutputter.setConfiguration(controller.getConfiguration());
        xPathContextMinor.setReceiver(sequenceOutputter);
        try {
            this.process(xPathContextMinor);
            return sequenceOutputter.getSequence().iterate(xPathContextMinor);
        }
        catch (XPathException xPathException) {
            if (xPathException instanceof ValidationException) {
                ((ValidationException)xPathException).setSourceLocator(this);
                ((ValidationException)xPathException).setSystemId(this.getSystemId());
            }
            if (xPathException.getLocator() == null) {
                xPathException.setLocator(this);
            }
            throw xPathException;
        }
    }
}

