/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import net.sf.saxon.Configuration;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.xpath.XPathException;

public class TreeReceiver
extends SequenceReceiver {
    private Receiver baseReceiver;
    private Configuration config;
    private String systemId;

    public TreeReceiver(Receiver receiver) {
        this.baseReceiver = receiver;
        this.previousAtomic = false;
        this.locator = receiver.getDocumentLocator();
    }

    public void setSystemId(String string) {
        if (string != this.systemId) {
            this.systemId = string;
            if (this.baseReceiver != null) {
                this.baseReceiver.setSystemId(string);
            }
        }
    }

    public String getSystemId() {
        return this.systemId;
    }

    public Receiver getUnderlyingReceiver() {
        return this.baseReceiver;
    }

    public void setConfiguration(Configuration configuration) {
        if (this.config != configuration) {
            this.config = configuration;
            if (this.baseReceiver != null) {
                this.baseReceiver.setConfiguration(configuration);
            }
        }
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setDocumentLocator(LocationProvider locationProvider) {
        this.locator = locationProvider;
        if (this.baseReceiver != null) {
            this.baseReceiver.setDocumentLocator(locationProvider);
        }
    }

    public void open() throws XPathException {
        if (this.baseReceiver == null) {
            throw new IllegalStateException("TreeReceiver.open(): no underlying receiver provided");
        }
        this.baseReceiver.open();
        this.previousAtomic = false;
    }

    public void close() throws XPathException {
        if (this.baseReceiver != null) {
            this.baseReceiver.close();
        }
        this.previousAtomic = false;
    }

    public void startDocument(int n) throws XPathException {
        if (this.baseReceiver != null) {
            this.baseReceiver.startDocument(n);
        }
    }

    public void endDocument() throws XPathException {
        if (this.baseReceiver != null) {
            this.baseReceiver.endDocument();
        }
    }

    public void startElement(int n, int n2, int n3, int n4) throws XPathException {
        if (this.baseReceiver != null) {
            this.baseReceiver.startElement(n, n2, n3, n4);
        }
        this.previousAtomic = false;
    }

    public void namespace(int n, int n2) throws XPathException {
        if (this.baseReceiver != null) {
            this.baseReceiver.namespace(n, n2);
        }
        this.previousAtomic = false;
    }

    public void attribute(int n, int n2, CharSequence charSequence, int n3, int n4) throws XPathException {
        if (this.baseReceiver != null) {
            this.baseReceiver.attribute(n, n2, charSequence, n3, n4);
        }
        this.previousAtomic = false;
    }

    public void startContent() throws XPathException {
        if (this.baseReceiver != null) {
            this.baseReceiver.startContent();
        }
        this.previousAtomic = false;
    }

    public void endElement() throws XPathException {
        if (this.baseReceiver != null) {
            this.baseReceiver.endElement();
        }
        this.previousAtomic = false;
    }

    public void characters(CharSequence charSequence, int n, int n2) throws XPathException {
        if (this.baseReceiver != null) {
            this.baseReceiver.characters(charSequence, n, n2);
        }
        this.previousAtomic = false;
    }

    public void processingInstruction(String string, CharSequence charSequence, int n, int n2) throws XPathException {
        if (this.baseReceiver != null) {
            this.baseReceiver.processingInstruction(string, charSequence, n, n2);
        }
        this.previousAtomic = false;
    }

    public void comment(CharSequence charSequence, int n, int n2) throws XPathException {
        if (this.baseReceiver != null) {
            this.baseReceiver.comment(charSequence, n, n2);
        }
        this.previousAtomic = false;
    }

    public void setUnparsedEntity(String string, String string2, String string3) throws XPathException {
        if (this.baseReceiver != null) {
            this.baseReceiver.setUnparsedEntity(string, string2, string3);
        }
    }

    public void append(Item item, int n) throws XPathException {
        if (item instanceof AtomicValue) {
            if (this.previousAtomic) {
                this.characters(" ", n, 0);
            }
            this.characters(item.getStringValue(), n, 0);
            this.previousAtomic = true;
        } else if (item instanceof DocumentInfo) {
            Item item2;
            AxisIterator axisIterator = ((DocumentInfo)item).iterateAxis((byte)3);
            while ((item2 = axisIterator.next()) != null) {
                this.append(item2, n);
            }
        } else {
            ((NodeInfo)item).copy(this, 2, true, n);
            this.previousAtomic = false;
        }
    }
}

