/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.PrintStream;
import java.util.Iterator;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.ArrayIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.xpath.XPathException;

public class TailExpression
extends ComputedExpression {
    Expression base;
    int start;

    public TailExpression(Expression expression, int n) {
        this.base = expression;
        this.start = n;
    }

    public Expression analyze(StaticContext staticContext, ItemType itemType) {
        return this;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        Expression expression = promotionOffer.accept(this);
        if (expression != null) {
            return expression;
        }
        if (promotionOffer.action != 13) {
            this.base = this.base.promote(promotionOffer);
        }
        return this;
    }

    public int computeSpecialProperties() {
        return this.base.getSpecialProperties();
    }

    public ItemType getItemType() {
        return this.base.getItemType();
    }

    public int computeCardinality() {
        return this.base.getCardinality() | 0x100;
    }

    public Iterator iterateSubExpressions() {
        return new MonoIterator(this.base);
    }

    public Expression getBaseExpression() {
        return this.base;
    }

    public int getStart() {
        return this.start;
    }

    public boolean equals(Object object) {
        return object instanceof TailExpression && this.base.equals(((TailExpression)object).base);
    }

    public int hashCode() {
        return this.base.hashCode();
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.base.iterate(xPathContext);
        if (sequenceIterator instanceof ArrayIterator) {
            return ((ArrayIterator)sequenceIterator).makeSliceIterator(this.start, Integer.MAX_VALUE);
        }
        return new TailIterator(sequenceIterator, this.start);
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        printStream.println(ExpressionTool.indent(n) + "tail " + this.start);
        this.base.display(n + 1, namePool, printStream);
    }

    public static class TailIterator
    implements SequenceIterator {
        private SequenceIterator base;
        private int start;

        public TailIterator(SequenceIterator sequenceIterator, int n) throws XPathException {
            this.base = sequenceIterator;
            this.start = n;
            int n2 = 0;
            while (n2 < n - 1) {
                sequenceIterator.next();
                ++n2;
            }
        }

        public Item next() throws XPathException {
            return this.base.next();
        }

        public Item current() {
            return this.base.current();
        }

        public int position() {
            return this.base.position() - this.start + 1;
        }

        public SequenceIterator getAnother() throws XPathException {
            return new TailIterator(this.base.getAnother(), this.start);
        }
    }
}

