/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.xpath.XPathException;

public final class UntypedAtomicConverter
extends UnaryExpression
implements MappingFunction {
    private AtomicType requiredItemType;

    public UntypedAtomicConverter(Expression expression, AtomicType atomicType) {
        super(expression);
        this.requiredItemType = atomicType;
        ExpressionTool.copyLocationInfo(expression, this);
    }

    public Expression analyze(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.operand = this.operand.analyze(staticContext, itemType);
        ItemType itemType2 = this.operand.getItemType();
        if (itemType2 instanceof NodeTest) {
            return this;
        }
        if (itemType2 == Type.ANY_ATOMIC_TYPE || itemType2 instanceof AnyItemType || itemType2 == Type.UNTYPED_ATOMIC_TYPE) {
            return this;
        }
        return this.operand;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.operand.iterate(xPathContext);
        return new MappingIterator(sequenceIterator, this, null, null);
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Item item = this.operand.evaluateItem(xPathContext);
        if (item == null) {
            return null;
        }
        if (item instanceof UntypedAtomicValue) {
            return ((UntypedAtomicValue)item).convert(this.requiredItemType, xPathContext);
        }
        return item;
    }

    public Object map(Item item, XPathContext xPathContext, Object object) throws XPathException {
        if (item instanceof UntypedAtomicValue) {
            return ((UntypedAtomicValue)item).convert(this.requiredItemType, xPathContext);
        }
        return item;
    }

    protected String displayOperator(NamePool namePool) {
        return "convert untyped atomic items to " + this.requiredItemType.toString(namePool);
    }
}

