/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.util.HashMap;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.Procedure;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trace.InstructionInfoProvider;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public final class UserFunction
extends Procedure
implements InstructionInfoProvider {
    private int functionNameCode;
    private boolean memoFunction = false;
    private SequenceType[] argumentTypes;
    private SequenceType resultType;
    private transient InstructionDetails details = null;

    public UserFunction() {
    }

    public UserFunction(Expression expression) {
        this.setBody(expression);
    }

    public void setArgumentTypes(SequenceType[] sequenceTypeArray) {
        this.argumentTypes = sequenceTypeArray;
    }

    public void setResultType(SequenceType sequenceType) {
        this.resultType = sequenceType;
    }

    public int getFunctionFingerprint() {
        return this.getFunctionNameCode() & 0xFFFFF;
    }

    public String getFunctionDisplayName(NamePool namePool) {
        return namePool.getDisplayName(this.getFunctionNameCode());
    }

    public SequenceType getResultType() {
        return this.resultType;
    }

    public SequenceType[] getArgumentTypes() {
        return this.argumentTypes;
    }

    public int getNumberOfArguments() {
        return this.argumentTypes.length;
    }

    public void setMemoFunction(boolean bl) {
        this.memoFunction = bl;
    }

    public void setFunctionNameCode(int n) {
        this.functionNameCode = n;
    }

    public int getFunctionNameCode() {
        return this.functionNameCode;
    }

    public Value call(Value[] valueArray, XPathContextMajor xPathContextMajor, boolean bl) throws XPathException {
        Value value;
        Controller controller = xPathContextMajor.getController();
        if (this.memoFunction && (value = this.getCachedValue(controller, valueArray)) != null) {
            return value;
        }
        xPathContextMajor.setStackFrame(this.getStackFrameMap(), valueArray);
        try {
            value = ExpressionTool.eagerEvaluate(this.getBody(), xPathContextMajor);
        }
        catch (XPathException xPathException) {
            xPathException.setLocator(this);
            throw xPathException;
        }
        if (bl) {
            while (value instanceof UserFunctionCall.FunctionCallPackage) {
                value = ((UserFunctionCall.FunctionCallPackage)value).call();
            }
        }
        if (this.memoFunction) {
            this.putCachedValue(controller, valueArray, value);
        }
        return value;
    }

    public Value call(Value[] valueArray, Controller controller) throws XPathException {
        return this.call(valueArray, controller.newXPathContext(), true);
    }

    private Value getCachedValue(Controller controller, Value[] valueArray) {
        try {
            HashMap hashMap = (HashMap)controller.getUserData(this, "memo-function-cache");
            if (hashMap == null) {
                return null;
            }
            String string = UserFunction.getCombinedKey(valueArray);
            return (Value)hashMap.get(string);
        }
        catch (XPathException xPathException) {
            return null;
        }
    }

    private void putCachedValue(Controller controller, Value[] valueArray, Value value) {
        try {
            HashMap<String, Value> hashMap = (HashMap<String, Value>)controller.getUserData(this, "memo-function-cache");
            if (hashMap == null) {
                hashMap = new HashMap<String, Value>(32);
                controller.setUserData(this, "memo-function-cache", hashMap);
            }
            String string = UserFunction.getCombinedKey(valueArray);
            hashMap.put(string, value);
        }
        catch (XPathException xPathException) {}
    }

    private static String getCombinedKey(Value[] valueArray) throws XPathException {
        StringBuffer stringBuffer = new StringBuffer(120);
        int n = 0;
        while (n < valueArray.length) {
            Item item;
            Value value = valueArray[n];
            SequenceIterator sequenceIterator = value.iterate(null);
            while ((item = sequenceIterator.next()) != null) {
                if (item instanceof NodeInfo) {
                    NodeInfo nodeInfo = (NodeInfo)item;
                    stringBuffer.append(nodeInfo.generateId());
                } else {
                    stringBuffer.append("" + Type.displayTypeName(item));
                    stringBuffer.append('/');
                    stringBuffer.append(item.getStringValue());
                }
                stringBuffer.append('\u0001');
            }
            stringBuffer.append('\u0002');
            ++n;
        }
        return stringBuffer.toString();
    }

    public InstructionInfo getInstructionInfo() {
        if (this.details == null) {
            this.details = new InstructionDetails();
            this.details.setSystemId(this.getSystemId());
            this.details.setLineNumber(this.getLineNumber());
            this.details.setConstructType(149);
            this.details.setObjectNameCode(this.functionNameCode);
            this.details.setProperty("function", this);
        }
        return this.details;
    }
}

