/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.Err;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.Facet;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.DynamicError;
import net.sf.saxon.xpath.XPathException;

public class DerivedAtomicValue
extends AtomicValue {
    AtomicValue primitiveValue;
    AtomicType typeLabel;

    private DerivedAtomicValue() {
    }

    public static DerivedAtomicValue makeValue(AtomicValue atomicValue, String string, AtomicType atomicType, boolean bl) throws XPathException {
        DerivedAtomicValue derivedAtomicValue = new DerivedAtomicValue();
        derivedAtomicValue.primitiveValue = atomicValue;
        derivedAtomicValue.typeLabel = atomicType;
        XPathException xPathException = derivedAtomicValue.checkAgainstFacets(string);
        if (xPathException != null) {
            if (bl) {
                throw xPathException;
            }
            return null;
        }
        return derivedAtomicValue;
    }

    public AtomicValue getPrimitiveValue() {
        return this.primitiveValue;
    }

    private XPathException checkAgainstFacets(String string) {
        Iterator iterator = this.typeLabel.getFacets();
        StringValue stringValue = null;
        while (iterator.hasNext()) {
            Facet facet = (Facet)iterator.next();
            if (facet.getName().equals("pattern")) {
                if (stringValue == null) {
                    stringValue = string == null ? new StringValue(this.primitiveValue.getStringValue()) : new StringValue(this.typeLabel.applyWhitespaceNormalization(string));
                }
                if (facet.testAtomicValue(stringValue)) continue;
                return new DynamicError("Value " + Err.wrap(stringValue.toString(), 4) + " violates the pattern facet " + (facet.getValue() == null ? "" : Err.wrap(facet.getValue(), 4) + " ") + "of the type " + this.typeLabel.getDescription());
            }
            if (facet.testAtomicValue(this.primitiveValue)) continue;
            return new DynamicError("Value " + Err.wrap(this.displayValue(), 4) + " violates the " + facet.getName() + " facet " + (facet.getValue() == null ? "" : Err.wrap(facet.getValue(), 4) + " ") + "of the type " + this.typeLabel.getDescription());
        }
        return null;
    }

    private String displayValue() {
        String string = this.primitiveValue.getStringValue();
        if (string.length() > 30) {
            string = string.substring(0, 30) + "...";
        }
        return string;
    }

    public AtomicValue convert(int n, XPathContext xPathContext) throws XPathException {
        return this.primitiveValue.convert(n, xPathContext);
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        return this;
    }

    public String getStringValue() {
        return this.primitiveValue.getStringValue();
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) {
        return this.primitiveValue.effectiveBooleanValue(xPathContext);
    }

    public Object convertToJava(Class clazz, Configuration configuration, XPathContext xPathContext) throws XPathException {
        return this.primitiveValue.convertToJava(clazz, configuration, xPathContext);
    }

    public ItemType getItemType() {
        return this.typeLabel;
    }

    public int hashCode() {
        return this.primitiveValue.hashCode();
    }

    public boolean equals(Object object) {
        return this.primitiveValue.equals(object);
    }

    public String toString() {
        return this.primitiveValue.toString();
    }
}

