/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.Sender;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.type.BuiltInSchemaFactory;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Closure;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceIntent;
import net.sf.saxon.value.SingletonNode;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.DynamicError;
import net.sf.saxon.xpath.XPathException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class Value
implements Expression,
Serializable {
    public static Value asValue(Item item) {
        if (item == null) {
            return EmptySequence.getInstance();
        }
        if (item instanceof AtomicValue) {
            return (AtomicValue)item;
        }
        return new SingletonNode((NodeInfo)item);
    }

    public static Item asItem(Value value, XPathContext xPathContext) throws XPathException {
        if (value instanceof EmptySequence) {
            return null;
        }
        if (value instanceof SingletonNode) {
            return ((SingletonNode)value).getNode();
        }
        if (value instanceof AtomicValue) {
            return (AtomicValue)value;
        }
        if (value instanceof Closure) {
            return value.evaluateItem(xPathContext);
        }
        SequenceIterator sequenceIterator = value.iterate(xPathContext);
        Item item = sequenceIterator.next();
        if (item == null) {
            return null;
        }
        if (sequenceIterator.next() != null) {
            throw new AssertionError((Object)"Attempting to access a sequence as an item");
        }
        return item;
    }

    public static double stringToNumber(CharSequence charSequence) throws NumberFormatException {
        String string = Value.trimWhitespace(charSequence).toString();
        if ("INF".equals(string)) {
            return Double.POSITIVE_INFINITY;
        }
        if ("-INF".equals(string)) {
            return Double.NEGATIVE_INFINITY;
        }
        if ("NaN".equals(string)) {
            return Double.NaN;
        }
        return Double.parseDouble(string);
    }

    public static CharSequence normalizeWhitespace(CharSequence charSequence) {
        StringBuffer stringBuffer = new StringBuffer(charSequence.length());
        int n = 0;
        while (n < charSequence.length()) {
            char c = charSequence.charAt(n);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': {
                    stringBuffer.append(' ');
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        return stringBuffer;
    }

    public static CharSequence collapseWhitespace(CharSequence charSequence) {
        if (charSequence.length() == 0) {
            return charSequence;
        }
        StringBuffer stringBuffer = new StringBuffer(charSequence.length());
        boolean bl = true;
        int n = 0;
        while (n < charSequence.length()) {
            char c = charSequence.charAt(n);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (bl) break;
                    stringBuffer.append(' ');
                    bl = true;
                    break;
                }
                default: {
                    stringBuffer.append(c);
                    bl = false;
                }
            }
            ++n;
        }
        if (stringBuffer.charAt(stringBuffer.length() - 1) == ' ') {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        return stringBuffer;
    }

    public static CharSequence trimWhitespace(CharSequence charSequence) {
        if (charSequence.length() == 0) {
            return charSequence;
        }
        int n = 0;
        int n2 = charSequence.length() - 1;
        while (charSequence.charAt(n) <= ' ') {
            if (n++ < n2) continue;
            return "";
        }
        while (charSequence.charAt(n2) <= ' ') {
            --n2;
        }
        return charSequence.subSequence(n, n2 + 1);
    }

    public final Expression simplify(StaticContext staticContext) {
        return this;
    }

    public final Expression analyze(StaticContext staticContext, ItemType itemType) {
        return this;
    }

    public final Iterator iterateSubExpressions() {
        return Collections.EMPTY_LIST.iterator();
    }

    public Container getParentExpression() {
        return null;
    }

    public int getSpecialProperties() {
        return 0;
    }

    public Expression promote(PromotionOffer promotionOffer) {
        return this;
    }

    public final int getDependencies() {
        return 0;
    }

    public static final int inverse(int n) {
        switch (n) {
            case 6: 
            case 22: 
            case 44: 
            case 45: {
                return n;
            }
            case 12: {
                return 11;
            }
            case 14: {
                return 13;
            }
            case 11: {
                return 12;
            }
            case 13: {
                return 14;
            }
            case 47: {
                return 46;
            }
            case 49: {
                return 48;
            }
            case 46: {
                return 47;
            }
            case 48: {
                return 49;
            }
        }
        return n;
    }

    public abstract String getStringValue() throws XPathException;

    public abstract Object convertToJava(Class var1, Configuration var2, XPathContext var3) throws XPathException;

    public static Value convertJavaObjectToXPath(Object object, Controller controller) throws XPathException {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return new StringValue((String)object);
        }
        if (object instanceof Character) {
            return new StringValue(object.toString());
        }
        if (object instanceof Boolean) {
            return BooleanValue.get((Boolean)object);
        }
        if (object instanceof Double) {
            return new DoubleValue((Double)object);
        }
        if (object instanceof Float) {
            return new FloatValue(((Float)object).floatValue());
        }
        if (object instanceof Short) {
            return new IntegerValue(((Short)object).shortValue(), (ItemType)((Object)BuiltInSchemaFactory.getSchemaType(537)));
        }
        if (object instanceof Integer) {
            return new IntegerValue(((Integer)object).intValue(), (ItemType)((Object)BuiltInSchemaFactory.getSchemaType(536)));
        }
        if (object instanceof Long) {
            return new IntegerValue((Long)object, (ItemType)((Object)BuiltInSchemaFactory.getSchemaType(535)));
        }
        if (object instanceof Byte) {
            return new IntegerValue(((Byte)object).byteValue(), (ItemType)((Object)BuiltInSchemaFactory.getSchemaType(538)));
        }
        if (object instanceof BigInteger) {
            return BigIntegerValue.makeValue((BigInteger)object);
        }
        if (object instanceof BigDecimal) {
            return new DecimalValue((BigDecimal)object);
        }
        if (object instanceof Closure) {
            return ExpressionTool.eagerEvaluate((Closure)object, null);
        }
        if (object instanceof Value) {
            return (Value)object;
        }
        if (object instanceof NodeInfo) {
            return new SingletonNode((NodeInfo)object);
        }
        if (object instanceof SequenceIterator) {
            return new SequenceIntent((SequenceIterator)object);
        }
        if (object instanceof List) {
            Item[] itemArray = new Item[((List)object).size()];
            int n = 0;
            Iterator iterator = ((List)object).iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof NodeInfo) {
                    itemArray[n++] = (NodeInfo)e;
                    continue;
                }
                Value value = Value.convertJavaObjectToXPath(e, controller);
                if (value == null) continue;
                if (value instanceof Item) {
                    itemArray[n++] = (Item)((Object)value);
                    continue;
                }
                if (value instanceof EmptySequence) continue;
                if (value instanceof SingletonNode) {
                    NodeInfo nodeInfo = ((SingletonNode)value).getNode();
                    if (nodeInfo == null) continue;
                    itemArray[n++] = nodeInfo;
                    continue;
                }
                throw new DynamicError("Returned List contains an object that cannot be converted to an Item (" + e.getClass() + ')');
            }
            return new SequenceExtent(itemArray);
        }
        if (object instanceof Object[]) {
            Item[] itemArray = new Item[((Object[])object).length];
            int n = 0;
            int n2 = 0;
            while (n2 < ((Object[])object).length) {
                Object object2 = ((Object[])object)[n2];
                if (object2 instanceof NodeInfo) {
                    itemArray[n++] = (NodeInfo)object2;
                } else {
                    Value value = Value.convertJavaObjectToXPath(object2, controller);
                    if (value != null) {
                        if (value instanceof Item) {
                            itemArray[n++] = (Item)((Object)value);
                        } else {
                            throw new DynamicError("Returned array contains an object that cannot be converted to an Item (" + object2.getClass() + ')');
                        }
                    }
                }
                ++n2;
            }
            return new SequenceExtent(itemArray);
        }
        if (object instanceof long[]) {
            Item[] itemArray = new Item[((long[])object).length];
            int n = 0;
            while (n < ((long[])object).length) {
                itemArray[n] = new IntegerValue(((long[])object)[n]);
                ++n;
            }
            return new SequenceExtent(itemArray);
        }
        if (object instanceof int[]) {
            Item[] itemArray = new Item[((int[])object).length];
            int n = 0;
            while (n < ((int[])object).length) {
                itemArray[n] = new IntegerValue(((int[])object)[n]);
                ++n;
            }
            return new SequenceExtent(itemArray);
        }
        if (object instanceof short[]) {
            Item[] itemArray = new Item[((short[])object).length];
            int n = 0;
            while (n < ((short[])object).length) {
                itemArray[n] = new IntegerValue(((short[])object)[n]);
                ++n;
            }
            return new SequenceExtent(itemArray);
        }
        if (object instanceof byte[]) {
            Item[] itemArray = new Item[((byte[])object).length];
            int n = 0;
            while (n < ((byte[])object).length) {
                itemArray[n] = new IntegerValue(0xFF & ((byte[])object)[n]);
                ++n;
            }
            return new SequenceExtent(itemArray);
        }
        if (object instanceof char[]) {
            return new StringValue(new String((char[])object));
        }
        if (object instanceof boolean[]) {
            Item[] itemArray = new Item[((boolean[])object).length];
            int n = 0;
            while (n < ((boolean[])object).length) {
                itemArray[n] = BooleanValue.get(((boolean[])object)[n]);
                ++n;
            }
            return new SequenceExtent(itemArray);
        }
        if (object instanceof Source && controller != null) {
            if (object instanceof DOMSource) {
                return new SingletonNode(controller.prepareInputTree((Source)object));
            }
            try {
                Builder builder = controller.makeBuilder();
                new Sender(controller.getConfiguration()).send((Source)object, builder);
                return new SingletonNode(builder.getCurrentDocument());
            }
            catch (XPathException xPathException) {
                throw new DynamicError(xPathException);
            }
        }
        if (object instanceof NodeList) {
            NodeList nodeList = (NodeList)object;
            Item[] itemArray = new NodeInfo[nodeList.getLength()];
            int n = 0;
            while (n < nodeList.getLength()) {
                if (!(nodeList.item(n) instanceof NodeInfo)) {
                    throw new DynamicError("Supplied NodeList contains non-Saxon DOM Nodes");
                }
                itemArray[n] = (NodeInfo)((Object)nodeList.item(n));
                ++n;
            }
            return new SequenceExtent(itemArray);
        }
        if (object instanceof Node) {
            throw new DynamicError("Supplied Java object is a non-Saxon DOM Node");
        }
        return new ObjectValue(object);
    }

    public String toString() {
        try {
            return this.getStringValue();
        }
        catch (XPathException xPathException) {
            return super.toString();
        }
    }
}

